/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.FramePayload;
import com.kontakt.sdk.android.ble.discovery.secure_profile.ResolveListener;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public abstract class PayloadResolver {
    protected final byte payloadId;
    private ResolveListener listener;

    public PayloadResolver(byte payloadId) {
        this.payloadId = payloadId;
    }

    void attachListener(ResolveListener listener) {
        this.listener = SDKPreconditions.checkNotNull(listener, "Listener cannot be null");
    }

    public abstract void resolve(FramePayload var1);

    protected void onPayloadResolved(SecureProfile profile) {
        if (this.listener != null) {
            this.listener.onResolved(profile);
        }
    }

    protected byte[] getServiceData(FramePayload payload) {
        return payload.getData(FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
    }

    protected String getName(FramePayload payload) {
        byte[] nameData = payload.getData(FrameDataType.LOCAL_NAME);
        if (nameData == null) {
            return null;
        }
        return new String(nameData);
    }
}

