package com.kontakt.sdk.android.common.util;

/**
 * Provides checking methods for different properties of iBeacon devices.
 *
 * @see <a href="http://docs.kontakt.io/beacon/kontakt-beacon-v2.pdf" target="_blank">kontakt.io Beacon Datasheet - version 2.0</a>
 */
public final class IBeaconPropertyValidator {

  private IBeaconPropertyValidator() {
  }

  private static final int MAX_MAJOR = Double.valueOf(Math.pow(2, 16)).intValue();
  private static final int MAX_MINOR = Double.valueOf(Math.pow(2, 16)).intValue();
  private static final int MODEL_NAME_MAX_LENGTH = 16;

  /**
   * Validates Beacon major value the value should be within the range [0, 65535].
   *
   * @param major the major
   */
  public static void validateMajor(final int major) {
    SDKPreconditions.checkArgument(major >= 0 && major < MAX_MAJOR, "Allowed range of major value: [1...65535]");
  }

  /**
   * Validates Beacon minor value the value should be within the range [0, 65535]
   *
   * @param minor the minor
   */
  public static void validateMinor(final int minor) {
    SDKPreconditions.checkArgument(minor >= 0 && minor < MAX_MINOR, "Allowed range of minor value: [1...65535]");
  }
}
