package com.kontakt.sdk.android.common.model;

/**
 * Enumeration type of specification.
 */
public enum Specification {

  /**
   * Standard specification.
   */
  STANDARD,

  /**
   * Sensored specification.
   */
  SENSORED,

  /**
   * Tough specification.
   */
  TOUGH,

  /**
   * External specification.
   */
  EXTERNAL;

  public static Specification fromString(String specificationString) {
    if (specificationString != null) {
      for (Specification specification : Specification.values()) {
        if (specificationString.equalsIgnoreCase(specification.name())) {
          return specification;
        }
      }
    }
    return STANDARD;
  }

}
