package com.kontakt.sdk.android.common.model;

/**
 * Enum representing a power saving feature.
 */
public enum PowerSavingFeature {

  LIGHT_SENSOR,
  RTC,
  MOTION_DETECTION;

  /**
   * Returns PowerSavingFeature parsed from given string.
   *
   * @param value Input string.
   * @return {@link PowerSavingFeature} object or null if not applicable.
   */
  public static PowerSavingFeature fromString(String value) {
    for (PowerSavingFeature feature : PowerSavingFeature.values()) {
      if (feature.toString().equalsIgnoreCase(value)) {
        return feature;
      }
    }
    return null;
  }

}
