package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Presets;
import com.kontakt.sdk.android.common.model.Preset;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface PresetsService {

  @GET("/preset/{name}")
  Call<Preset> getPreset(@Path("name") String name);

  @GET("/preset")
  Call<Presets> getPresets(@QueryMap Map<String, String> params);

  @GET("/preset")
  Call<Presets> getPresets(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);
}
