package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Managers;
import com.kontakt.sdk.android.common.model.Manager;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface ManagersService {

  @GET("/manager/{id}")
  Call<Manager> getManager(@Path("id") String id);

  @GET("/manager")
  Call<Managers> getManagers(@QueryMap Map<String, String> params);

  @GET("/manager")
  Call<Managers> getManagers(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET("/manager/{id}/subordinate")
  Call<Managers> getManagerSubOrdinates(@Path("id") String id, @QueryMap Map<String, String> params);

  @GET("/manager/{id}/subordinate")
  Call<Managers> getManagerSubOrdinates(@Path("id") String id, @QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @FormUrlEncoded
  @POST("/manager/create")
  Call<Manager> createManager(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/manager/update")
  Call<String> updateManager(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/manager/delete")
  Call<String> deleteManager(@FieldMap Map<String, String> params);
}
