package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Activities;
import com.kontakt.sdk.android.common.model.Activity;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.QueryMap;

public interface ActivitiesService {

  @GET("/activity")
  Call<Activities> getActivity(@QueryMap Map<String, String> params);

  @GET("/activity")
  Call<Activities> getActivities(@QueryMap Map<String, String> params);

  @GET("/activity")
  Call<Activities> getActivities(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @FormUrlEncoded
  @POST("/activity/create")
  Call<Activity> create(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/activity/update")
  Call<String> update(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/activity/delete")
  Call<String> delete(@FieldMap Map<String, String> params);
}
