package com.kontakt.sdk.android.cloud.api.executor.places;

import com.kontakt.sdk.android.cloud.api.PlacesApi;
import com.kontakt.sdk.android.cloud.api.executor.FileRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PlacesService;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Call;

/**
 * Request executor provided by {@link PlacesApi}. Use this class if you want to fetch
 * place's schema image file, for example:
 * <pre>
 *   <code>
 *   KontaktCloud kontaktCloud = KontaktCloudFactory.create();
 *   FileData imageFile = kontaktCloud.places().schemaImageOf(placeID).execute();
 *   </code>
 * </pre>
 */
public class PlaceSchemaImageRequestExecutor extends FileRequestExecutor {

  private final PlacesService placesService;

  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and venue's id.
   *
   * @param placesService the places API service.
   * @param id the place's identifier.
   */
  public PlaceSchemaImageRequestExecutor(PlacesService placesService, UUID id) {
    this.placesService = placesService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<ResponseBody> prepareCall() {
    return placesService.getPlaceSchemaImage(id.toString());
  }
}
