package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.util.ErrorUtils;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class CloudCallbackWrapper<T> implements Callback<T> {

  private final CloudCallback<T> callback;

  public CloudCallbackWrapper(final CloudCallback<T> callback) {
    this.callback = callback;
  }

  @Override
  public void onResponse(Call<T> call, Response<T> response) {
    Map<String, String> headers = new HashMap<>();
    for (String key : response.headers().names()) {
      headers.put(key, response.headers().get(key));
    }
    if (response.isSuccessful()) {
      T body = response.body();
      callback.onSuccess(body, CloudHeaders.of(headers));
    } else {
      CloudError cloudError = ErrorUtils.parseError(response);
      callback.onError(cloudError);
    }
  }

  @Override
  public void onFailure(Call<T> call, Throwable t) {
    CloudError error = new CloudError(null, -1, t.getLocalizedMessage());
    callback.onError(error);
  }
}
