package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.notifications.RegisterTokenRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.NotificationsService;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class NotificationsApi {

  private final NotificationsService notificationsService;

  public NotificationsApi(final NotificationsService notificationsService) {
    this.notificationsService = notificationsService;
  }

  public RegisterTokenRequestExecutor registerToken(final String token) {
    SDKPreconditions.checkNotNullOrEmpty(token, "token cannot be null");
    return new RegisterTokenRequestExecutor(notificationsService, token);
  }
}
