package com.kontakt.sdk.android.ble.spec;

import android.os.Parcel;
import android.os.Parcelable;

import static com.kontakt.sdk.android.common.util.ConversionUtils.asInt;

public class Acceleration implements Parcelable {

  public static final Parcelable.Creator<Acceleration> CREATOR = new Parcelable.Creator<Acceleration>() {
    @Override
    public Acceleration createFromParcel(Parcel source) {
      return new Acceleration(source);
    }

    @Override
    public Acceleration[] newArray(int size) {
      return new Acceleration[size];
    }
  };

  private final int x;
  private final int y;
  private final int z;

  public Acceleration(int x, int y, int z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  public Acceleration(byte[] accelerationData) {
    if (accelerationData == null || accelerationData.length != 3) {
      throw new IllegalArgumentException("Wrong acceleration data");
    }
    this.x = accelerationData[0];
    this.y = accelerationData[1];
    this.z = accelerationData[2];
  }

  protected Acceleration(Parcel in) {
    this.x = in.readInt();
    this.y = in.readInt();
    this.z = in.readInt();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Acceleration that = (Acceleration) o;

    if (x != that.x) return false;
    if (y != that.y) return false;
    return z == that.z;
  }

  @Override
  public int hashCode() {
    int result = x;
    result = 31 * result + y;
    result = 31 * result + z;
    return result;
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    dest.writeInt(this.x);
    dest.writeInt(this.y);
    dest.writeInt(this.z);
  }

  public int getX() {
    return x;
  }

  public int getY() {
    return y;
  }

  public int getZ() {
    return z;
  }
}
