package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanSettings;
import android.os.Build;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
final class ScanCompatL extends ScanCompat {

  public ScanConfiguration createScanConfiguration(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
    final BleScanCallback callback = MonitorCallback.create(scanContext, cache, eventCollector);
    final BleScanCallback callbackL = MonitorCallbackL.wrap(callback);
    final ScanSettings scanSettings = new ScanSettings.Builder()
        .setScanMode(scanContext.getScanMode().getCode())
        .build();

    return new AbstractScanConfigurationL(scanContext, callbackL) {
      @Override
      public ScanSettings getScanSettings() {
        return scanSettings;
      }
    };
  }

  public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
    return new ScanController.Builder().setScanPeriod(configuration.getScanContext().getScanPeriod())
        .setScanActiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration))
        .setScanPassiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration))
        .setForceScanScheduler(forceScanScheduler)
        .build();
  }

  public ForceScanScheduler createForceScanScheduler(final ScanConfiguration configuration) {
    final ScanContext scanContext = configuration.getScanContext();
    if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
      return ForceScanScheduler.DISABLED;
    }
    return new ForceScanScheduler(RunnersL.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
  }

}
