package com.kontakt.sdk.android.ble.security.property;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import static com.kontakt.sdk.android.common.util.SDKPreconditions.checkArgument;

public class UInt32Property extends AbstractProperty<Integer> {
  private static final int UINT32_SIZE = 4;
  private int value;

  public UInt32Property(PropertyID id, int value) {
    super(id);
    this.value = value;
  }

  public UInt32Property(PropertyID id, byte[] value) {
    super(id);
    checkArgument(value.length == UINT32_SIZE);
    this.value = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN).getInt();
  }

  @Override
  public byte[] getBytes() {
    return ByteBuffer.allocate(UINT32_SIZE).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
  }

  @Override
  public byte getSize() {
    return UINT32_SIZE;
  }

  @Override
  public Integer getValue() {
    return value;
  }
}
