package com.kontakt.sdk.android.ble.security.property;

import static com.kontakt.sdk.android.common.util.SDKPreconditions.checkArgument;

/**
 * Works for both signed and unsigned value
 */
public class Int8Property extends AbstractProperty<Byte> {
  private static final int INT8_SIZE = 1;
  private final int value;

  public Int8Property(PropertyID id, int value) {
    super(id);
    checkArgument(value <= Byte.MAX_VALUE && value >= Byte.MIN_VALUE, "Invalid uint value.");
    this.value = value;
  }

  public Int8Property(PropertyID id, byte[] value) {
    super(id);
    checkArgument(value.length == 1);
    this.value = value[0];
  }

  @Override
  public byte[] getBytes() {
    return new byte[] { (byte) value };
  }

  @Override
  public byte getSize() {
    return INT8_SIZE;
  }

  @Override
  public Byte getValue() {
    return (byte) value;
  }
}
