package com.kontakt.sdk.android.ble.manager.configuration;

import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilters;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilters;

import java.util.Collection;
import java.util.List;

public interface FiltersConfigurator {

  /**
   * Add single {@link IBeaconFilter}.
   * <br>
   * See {@link IBeaconFilters} for predefined filters.
   *
   * @param filter IBeacon filter to add
   * @return ProximityManagerFilters builder
   */
  FiltersConfigurator iBeaconFilter(IBeaconFilter filter);

  /**
   * Add multiple {@link IBeaconFilter}.
   * <br>
   * See {@link IBeaconFilters} for predefined filters.
   *
   * @param filters IBeacon filters to add
   * @return void builder
   */
  FiltersConfigurator iBeaconFilters(Collection<IBeaconFilter> filters);

  /**
   * Add single Eddystone {@link EddystoneFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filter Eddystone UID filter to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneFilter(EddystoneFilter filter);

  /**
   * Add multiple Eddystone {@link EddystoneFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filters Eddystone UID filters to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneFilters(Collection<EddystoneFilter> filters);

  /**
   * Returns currently set iBeacon filters.
   * @return unmodifiable list of iBeacon filters
   */
  List<IBeaconFilter> getIBeaconFilters();

  /**
   * Returns currently set Eddystone filters.
   * @return unmodifiable list of Eddystone filters
   */
  List<EddystoneFilter> getEddystoneFilters();

  /**
   * Clears all currently set IBeacon and Eddystone filters;
   */
  void clearAll();
}
