package com.kontakt.sdk.android.ble.dfu;

import com.kontakt.sdk.android.ble.exception.KontaktDfuException;

/**
 * Listener used to report status of firmware update.
 */
public interface FirmwareUpdateListener {

  /**
   * Called when firmware update is initialized.
   */
  void onStarted();

  /**
   * Called when firmware update has finished successfully.
   * @param totalDurationMillis - Total operation duration in milliseconds.
   */
  void onFinished(long totalDurationMillis);

  /**
   * Called during firmware update.
   * @param progressPercent Firmware update progress percentage. From 0 to 100.
   * @param progressStatus Test message with current progress status.
   */
  void onProgress(int progressPercent, String progressStatus);

  /**
   * Called when firmware update fails for any reason.
   * @param exception
   */
  void onError(KontaktDfuException exception);
}
