package com.kontakt.sdk.android.ble.configuration;

/**
 * ScanMode constants.
 */
public enum ScanMode {

  /**
   * Perform Bluetooth LE scan in low power mode. This is the default scan mode as it consumes the
   * least power.
   */
  LOW_POWER(0),

  /**
   * Perform Bluetooth LE scan in balanced power mode. Scan results are returned at a rate that
   * provides a good trade-off between scan frequency and power consumption.
   */
  BALANCED(1),

  /**
   * Scan using highest duty cycle. It's recommended to only use this mode when the application is
   * running in the foreground.
   */
  LOW_LATENCY(2);

  private final int code;

  ScanMode(int code) {
    this.code = code;
  }

  public int getCode() {
    return code;
  }
}
