/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import android.text.TextUtils;
import android.util.Patterns;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class EddystonePropertyValidator {
    private EddystonePropertyValidator() {
    }

    public static void validateUrl(String url) {
        boolean validUrl = Patterns.WEB_URL.matcher(url).matches();
        if (!validUrl) {
            throw new IllegalArgumentException("url is not valid");
        }
        byte[] bytes = EddystoneUtils.serializeUrl(url);
        if (bytes.length == 0) {
            throw new IllegalArgumentException("url is empty");
        }
        if (bytes.length > 18) {
            throw new IllegalArgumentException("url length is over 18 bytes length");
        }
    }

    public static void validateStringWithLessLength(String string, String what, int length) {
        SDKPreconditions.checkArgument(string != null, what + " cannot be null");
        SDKPreconditions.checkArgument(!string.isEmpty(), what + " cannot be empty");
        SDKPreconditions.checkArgument(string.getBytes().length <= length, what + " cannot be larger than " + length + " bytes");
    }

    public static void validateStringWithExactLength(String string, String message, int length) {
        SDKPreconditions.checkArgument(string != null, message + " cannot be null");
        SDKPreconditions.checkArgument(!string.isEmpty(), message + " cannot be empty");
        SDKPreconditions.checkArgument(string.getBytes().length == length, message + " must be " + length + " bytes");
    }

    public static void validateInstanceId(byte[] hexedStringBytes) {
        SDKPreconditions.checkArgument(hexedStringBytes.length == 6, "InstanceId wrong bytes length");
    }

    public static void validateNamespace(byte[] hexedStringBytes) {
        SDKPreconditions.checkArgument(hexedStringBytes.length == 10, "Namespace wrong bytes length");
    }

    public static void validateHexString(String string) {
        SDKPreconditions.checkArgument(!TextUtils.isEmpty((CharSequence)string), "Hex String is empty");
        SDKPreconditions.checkArgument(EddystoneUtils.isStringOnlyHex(string), "String is not in hex format");
    }
}

