/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.managers.CreateManagerRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.managers.DeleteManagerRequestManager;
import com.kontakt.sdk.android.cloud.api.executor.managers.ManagerRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.managers.ManagersRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.managers.UpdateManagerRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ManagersService;
import com.kontakt.sdk.android.common.model.Manager;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public class ManagersApi {
    private final ManagersService managersService;

    public ManagersApi(ManagersService managersService) {
        this.managersService = managersService;
    }

    public ManagerRequestExecutor fetch(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new ManagerRequestExecutor(this.managersService, id);
    }

    public ManagersRequestExecutor fetch() {
        return new ManagersRequestExecutor(this.managersService);
    }

    public CreateManagerRequestExecutor create(Manager manager) {
        SDKPreconditions.checkNotNull(manager, "manager cannot be null");
        return new CreateManagerRequestExecutor(this.managersService, manager);
    }

    public UpdateManagerRequestExecutor update(UUID managerId) {
        SDKPreconditions.checkNotNull(managerId, "manager ID cannot be null");
        return new UpdateManagerRequestExecutor(this.managersService, managerId);
    }

    public DeleteManagerRequestManager delete(UUID managerId) {
        SDKPreconditions.checkNotNull(managerId, "manager ID cannot be null");
        return new DeleteManagerRequestManager(this.managersService, managerId);
    }
}

