/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.actions.ActionsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.actions.ContentActionFileRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.actions.CreateBrowserActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.actions.CreateContentActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.actions.DeleteActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.actions.UpdateBrowserActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.actions.UpdateContentActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public class ActionsApi {
    private final ActionsService actionsService;

    public ActionsApi(ActionsService actionsService) {
        this.actionsService = actionsService;
    }

    public ActionsRequestExecutor fetch() {
        return new ActionsRequestExecutor(this.actionsService);
    }

    public ContentActionFileRequestExecutor fileOf(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new ContentActionFileRequestExecutor(this.actionsService, id);
    }

    public CreateContentActionRequestExecutor createContentAction() {
        return new CreateContentActionRequestExecutor(this.actionsService);
    }

    public CreateBrowserActionRequestExecutor createBrowserAction() {
        return new CreateBrowserActionRequestExecutor(this.actionsService);
    }

    public UpdateContentActionRequestExecutor updateContentAction(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new UpdateContentActionRequestExecutor(this.actionsService, id);
    }

    public UpdateBrowserActionRequestExecutor updateBrowserAction(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new UpdateBrowserActionRequestExecutor(this.actionsService, id);
    }

    public DeleteActionRequestExecutor delete(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new DeleteActionRequestExecutor(this.actionsService, id);
    }
}

