/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.FirmwareVersion;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.EnumSet;

public final class DeviceUtils {
    private static final EnumSet<Model> SECURE_PROFILES = EnumSet.of(Model.GATEWAY, Model.BEACON_PRO, Model.PROBE);

    private DeviceUtils() {
    }

    public static boolean isSecure(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.isSecure(device.getModel(), device.getFirmware());
    }

    public static boolean isSecure(RemoteBluetoothDevice device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.isSecure(device.getModel(), device.getFirmwareVersion());
    }

    public static boolean isSecure(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        if (SECURE_PROFILES.contains((Object)model)) {
            return true;
        }
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("4.0");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean hasRtcAndLightSensorFeatures(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasRtcAndLightSensorFeatures(device.getModel(), device.getFirmware());
    }

    public static boolean hasRtcAndLightSensorFeatures(RemoteBluetoothDevice device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasRtcAndLightSensorFeatures(device.getModel(), device.getFirmwareVersion());
    }

    public static boolean hasRtcAndLightSensorFeatures(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("1.7");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return model == Model.BEACON_PRO && deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean canTransmitKontaktTelemetry(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.canTransmitKontaktTelemetry(device.getModel(), device.getFirmware());
    }

    public static boolean canTransmitKontaktTelemetry(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("1.10");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return model == Model.BEACON_PRO && deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean isInterleavingAvailable(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.isInterleavingAvailable(device.getModel(), device.getFirmware());
    }

    public static boolean isInterleavingAvailable(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        if (model == Model.BEACON_PRO) {
            return true;
        }
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("4.1");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }
}

