/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import com.kontakt.sdk.android.ble.discovery.ScanErrors;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.Collection;

@TargetApi(value=21)
abstract class MonitorCallbackL
extends ScanCallback
implements BleScanCallback {
    private final MonitorCallback wrappedScanCallback;

    static MonitorCallbackL wrap(BleScanCallback scanCallback) {
        return new MonitorCallbackL((MonitorCallback)scanCallback){};
    }

    private MonitorCallbackL(MonitorCallback scanCallback) {
        SDKPreconditions.checkNotNull(scanCallback, "Wrapped scan callback is null");
        this.wrappedScanCallback = scanCallback;
    }

    public void onScanResult(int callbackType, ScanResult result) {
        if (callbackType != 1) {
            return;
        }
        ScanRecord scanRecord = result.getScanRecord();
        if (scanRecord == null) {
            return;
        }
        this.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        this.wrappedScanCallback.onLeScan(device, rssi, scanRecord);
    }

    public void onScanFailed(int errorCode) {
        String message = ScanErrors.getMessage(errorCode);
        Logger.e(message);
        this.wrappedScanCallback.onScanError(new ScanError(message));
    }

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
        return this.wrappedScanCallback.getMonitoringListeners();
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
        this.wrappedScanCallback.addListener(proximityListener);
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
        this.wrappedScanCallback.removeListener(proximityListener);
    }

    @Override
    public void close() throws IOException {
        this.wrappedScanCallback.close();
    }

    void onMonitorStarted() {
        this.wrappedScanCallback.onMonitorCycleStart();
    }

    void onMonitorStopped() {
        this.wrappedScanCallback.onMonitorCycleStop();
    }
}

