/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.Parser;
import com.kontakt.sdk.android.ble.discovery.eddystone.InstanceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.NamespaceIdResolver;
import com.kontakt.sdk.android.ble.discovery.secure_profile.KontaktTLMResolver;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.Arrays;

final class SecureProfileParser
extends Parser<SecureProfile> {
    private static final byte[] KONTAKT_SECURE_PROFILE_PREFIX = new byte[]{22, 106, -2};
    private static final int MIN_SECURE_PROFILE_LENGTH = 14;
    private static final byte SHUFFLED_DEVICE_IDENTIFIER_PAYLOAD = 1;
    private static final byte PLAIN_DEVICE_IDENTIFIER_PAYLOAD = 2;
    private static final byte KONTAKT_TELEMETRY_IDENTIFIER_PAYLOAD = 3;
    private static final NamespaceIdResolver NAMESPACE_RESOLVER = new NamespaceIdResolver(8);
    private static final InstanceIdResolver INSTANCE_ID_RESOLVER = new InstanceIdResolver(18);
    private static final KontaktTLMResolver KONTAKT_TLM_RESOLVER = new KontaktTLMResolver();

    SecureProfileParser(ScanContext scanContext) {
        super(scanContext);
    }

    boolean isValidSecureProfileFrame(byte[] scanRecord) {
        return ConversionUtils.doesArrayContainSubset(scanRecord, KONTAKT_SECURE_PROFILE_PREFIX, 4) && scanRecord.length > 14;
    }

    void parseScanRecord(byte[] scanRecord) {
        this.frameData.clear();
        this.extractFrameData(scanRecord, this.frameData);
    }

    ISecureProfile getSecureProfile(BluetoothDevice device, int rssi) {
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        byte[] nameData = (byte[])this.frameData.get((Object)FrameDataType.LOCAL_NAME);
        byte payloadId = serviceData[2];
        boolean isShuffled = payloadId == 1;
        String name = this.parseName(nameData);
        SecureProfile cachedSecureDevice = this.getCachedSecureDevice(device.getAddress());
        SecureProfile.Builder builder = cachedSecureDevice != null ? new SecureProfile.Builder(cachedSecureDevice) : new SecureProfile.Builder();
        builder.macAddress(device.getAddress()).shuffled(isShuffled).name(name);
        if (payloadId == 2) {
            this.parsePlainDevicePayload(serviceData, builder);
        }
        if (payloadId == 1) {
            this.parseShuffledDevicePayload(serviceData, builder);
        }
        if (payloadId == 3) {
            this.parseTelemetryPayload(serviceData, builder);
        }
        SecureProfile secureProfile = builder.build();
        this.updateRssi(secureProfile, rssi);
        this.putSecureDeviceInCache(device.getAddress(), secureProfile);
        return secureProfile;
    }

    private void parsePlainDevicePayload(byte[] serviceData, SecureProfile.Builder builder) {
        Model model = Model.fromCode(serviceData[3]);
        String firmware = this.parseFirmwareVersion(serviceData);
        byte batteryLevel = serviceData[6];
        byte txPower = serviceData[7];
        String uniqueId = this.parseUniqueId(serviceData);
        builder.model(model).firmwareRevision(firmware).batteryLevel(batteryLevel).txPower(txPower).uniqueId(uniqueId);
    }

    private void parseShuffledDevicePayload(byte[] serviceData, SecureProfile.Builder builder) {
        Model model = Model.fromCode(serviceData[3]);
        String firmware = this.parseFirmwareVersion(serviceData);
        byte batteryLevel = serviceData[6];
        byte txPower = serviceData[7];
        String namespace = this.parseNamespace(serviceData);
        String shuffledInstanceId = this.parseShuffledInstanceId(serviceData);
        builder.model(model).firmwareRevision(firmware).batteryLevel(batteryLevel).txPower(txPower).namespace(namespace).instanceId(shuffledInstanceId);
    }

    private void parseTelemetryPayload(byte[] serviceData, SecureProfile.Builder builder) {
        KontaktTelemetry telemetry = KONTAKT_TLM_RESOLVER.parse(serviceData);
        builder.telemetry(telemetry);
    }

    private void putSecureDeviceInCache(String deviceAddress, SecureProfile device) {
        int hashCode = this.hashCodeBuilder.append(deviceAddress).build();
        this.devicesCache.put(hashCode, device);
    }

    SecureProfile getCachedSecureDevice(String deviceAddress) {
        int hashCode = this.hashCodeBuilder.append(deviceAddress).build();
        return (SecureProfile)this.devicesCache.get(hashCode);
    }

    private void updateRssi(SecureProfile device, int rssi) {
        int calculatedRssi = this.rssiCalculator.calculateRssi(device.getMacAddress().hashCode(), rssi);
        device.setRssi(calculatedRssi);
    }

    private String parseName(byte[] nameData) {
        if (nameData == null) {
            return null;
        }
        return new String(nameData);
    }

    private String parseFirmwareVersion(byte[] serviceData) {
        byte firmwareVersionMajor = serviceData[4];
        byte firmwareVersionMinor = serviceData[5];
        if (firmwareVersionMajor < 0 || firmwareVersionMinor < 0) {
            return "";
        }
        return String.format("%d.%d", firmwareVersionMajor, (int)firmwareVersionMinor);
    }

    private String parseUniqueId(byte[] serviceData) {
        return new String(Arrays.copyOfRange(serviceData, 8, serviceData.length));
    }

    private String parseNamespace(byte[] serviceData) {
        return NAMESPACE_RESOLVER.parse(serviceData);
    }

    private String parseShuffledInstanceId(byte[] serviceData) {
        return INSTANCE_ID_RESOLVER.parse(serviceData);
    }

    @Override
    protected void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
        }
    }
}

