/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;

final class NamespaceValidator
implements Validator<IEddystoneDevice, IEddystoneNamespace> {
    NamespaceValidator() {
    }

    @Override
    public boolean isValid(IEddystoneDevice eddystone, IEddystoneNamespace namespace) {
        if (namespace == EddystoneNamespace.EVERYWHERE) {
            return true;
        }
        String deviceNamespace = eddystone.getNamespace();
        String deviceInstanceId = eddystone.getInstanceId();
        if (deviceNamespace == null || deviceInstanceId == null) {
            return false;
        }
        if (deviceNamespace.equals(namespace.getNamespace())) {
            if ("Any instance ID".equals(namespace.getInstanceId())) {
                return true;
            }
            return deviceInstanceId.equals(namespace.getInstanceId());
        }
        return false;
    }
}

