/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.dfu;

import android.util.Base64;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceServiceStore;
import com.kontakt.sdk.android.ble.exception.CharacteristicAbsentException;
import com.kontakt.sdk.android.ble.exception.ServiceAbsentException;
import com.kontakt.sdk.android.ble.spec.BluetoothDeviceCharacteristic;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class DfuAuthorizationService {
    private final KontaktCloud kontaktCloud;
    private final RemoteBluetoothDevice device;
    private final KontaktDeviceServiceStore serviceStore;
    private final GattController gattController;
    private AuthorizationCallback authorizationCallback;

    public static DfuAuthorizationService create(RemoteBluetoothDevice device, KontaktCloud kontaktCloud, GattController gattController, KontaktDeviceServiceStore serviceStore) {
        return new DfuAuthorizationService(device, kontaktCloud, gattController, serviceStore);
    }

    DfuAuthorizationService(RemoteBluetoothDevice device, KontaktCloud kontaktCloud, GattController gattController, KontaktDeviceServiceStore serviceStore) {
        SDKPreconditions.checkNotNull(kontaktCloud);
        SDKPreconditions.checkNotNull(device);
        SDKPreconditions.checkNotNull(gattController);
        SDKPreconditions.checkNotNull(serviceStore);
        this.serviceStore = serviceStore;
        this.gattController = gattController;
        this.kontaktCloud = kontaktCloud;
        this.device = device;
    }

    public void setAuthorizationCallback(AuthorizationCallback authorizationCallback) {
        this.authorizationCallback = authorizationCallback;
    }

    public void authorize() {
        SDKPreconditions.checkNotNull(this.authorizationCallback, "AuthorizationCallback must be set first.");
        this.kontaktCloud.configs().readAll().withIds(this.device.getUniqueId()).execute(this.createCloudCallback());
    }

    private CloudCallback<Configs> createCloudCallback() {
        return new CloudCallback<Configs>(){

            @Override
            public void onSuccess(Configs response, CloudHeaders headers) {
                String command = ((Config)response.getContent().get(0)).getSecureRequest();
                if (command == null || command.trim().isEmpty()) {
                    DfuAuthorizationService.this.reportError("Authorization command is null or empty");
                    return;
                }
                DfuAuthorizationService.this.sendAuthorizationCommand(command);
            }

            @Override
            public void onError(CloudError error) {
                DfuAuthorizationService.this.reportError("Error while downloading authorization command: " + error.getMessage());
            }
        };
    }

    void sendAuthorizationCommand(String command) {
        BluetoothDeviceCharacteristic secureWriteCharacteristic;
        SDKPreconditions.checkNotNull(command, "Authorization command is null");
        try {
            secureWriteCharacteristic = this.serviceStore.getSecureWriteCharacteristic();
        }
        catch (CharacteristicAbsentException | ServiceAbsentException e) {
            this.reportError(e.getMessage());
            return;
        }
        byte[] decodedCommand = Base64.decode((String)command, (int)0);
        byte[] currentValue = secureWriteCharacteristic.getValue();
        secureWriteCharacteristic.setValue(decodedCommand);
        if (!this.gattController.writeCharacteristic(secureWriteCharacteristic, false)) {
            secureWriteCharacteristic.setValue(currentValue);
            this.reportError("Failed to write to characteristic: " + secureWriteCharacteristic.getName());
        }
    }

    void onAuthorizationCommandWriteSuccess() {
        if (this.authorizationCallback != null) {
            this.authorizationCallback.onAuthorized();
        }
    }

    void reportError(String message) {
        if (this.authorizationCallback != null) {
            this.authorizationCallback.onError(message);
        }
    }

    static interface AuthorizationCallback {
        public void onAuthorized();

        public void onError(String var1);
    }
}

