/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.text.TextUtils;
import com.kontakt.sdk.android.ble.connection.ErrorCause;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Preset;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class KontaktDeviceBatchProcessor {
    private static final String TAG = KontaktDeviceBatchProcessor.class.getSimpleName();
    private final Batch batch;
    final KontaktDeviceConnectionImpl kontaktDeviceConnection;
    Map.Entry<String, Object> currentEntry = null;

    static KontaktDeviceBatchProcessor from(Batch batch, KontaktDeviceConnectionImpl connection) {
        return new KontaktDeviceBatchProcessor(batch, connection);
    }

    private KontaktDeviceBatchProcessor(Batch batch, KontaktDeviceConnectionImpl connection) {
        this.batch = batch;
        this.kontaktDeviceConnection = connection;
    }

    void process(ProcessingListener processingListener) {
        processingListener.onStart();
        Iterator<Map.Entry<String, Object>> argumentIterator = this.batch.processIterator();
        if (this.batch.isProcessEmpty()) {
            this.kontaktDeviceConnection.finishWriteBatch();
            processingListener.onFinish();
            return;
        }
        if (argumentIterator.hasNext()) {
            this.process(argumentIterator, processingListener);
        }
    }

    void writeCheckNextArgument(Iterator<Map.Entry<String, Object>> argumentIterator, ProcessingListener processingListener) {
        if (argumentIterator.hasNext()) {
            argumentIterator.remove();
            this.process(argumentIterator, processingListener);
        } else {
            this.kontaktDeviceConnection.finishWriteBatch();
            processingListener.onFinish();
        }
    }

    void writeFailure(ProcessingListener processingListener) {
        int errorCode = KontaktDeviceBatchProcessor.getErrorCode(this.currentEntry.getKey());
        Logger.e(TAG + ": write operation finished with failure - error code = " + errorCode);
        processingListener.onError(KontaktDeviceBatchProcessor.getErrorCode(this.currentEntry.getKey()));
        this.performRollback(processingListener);
    }

    private void process(final Iterator<Map.Entry<String, Object>> argumentIterator, final ProcessingListener processingListener) {
        String key;
        WriteListener nextWriteListener = new WriteListener(){

            @Override
            public void onWriteSuccess(WriteListener.WriteResponse response) {
                KontaktDeviceBatchProcessor.this.writeCheckNextArgument(argumentIterator, processingListener);
            }

            @Override
            public void onWriteFailure(ErrorCause cause) {
                if (ErrorCause.FEATURE_NOT_SUPPORTED == cause) {
                    KontaktDeviceBatchProcessor.this.writeCheckNextArgument(argumentIterator, processingListener);
                } else {
                    KontaktDeviceBatchProcessor.this.writeFailure(processingListener);
                }
            }
        };
        this.currentEntry = argumentIterator.next();
        switch (key = this.currentEntry.getKey()) {
            case "url": {
                this.kontaktDeviceConnection.overwriteUrl((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "instanceId": {
                this.kontaktDeviceConnection.overwriteInstanceId((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "namespace": {
                this.kontaktDeviceConnection.overwriteNamespaceId((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "proximity": {
                this.kontaktDeviceConnection.overwriteProximityUUID((UUID)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "interval": {
                this.kontaktDeviceConnection.overwriteAdvertisingInterval((Long)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "txPower": {
                this.kontaktDeviceConnection.overwritePowerLevel((Integer)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "major": {
                this.kontaktDeviceConnection.overwriteMajor((Integer)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "minor": {
                this.kontaktDeviceConnection.overwriteMinor((Integer)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "profiles": {
                this.kontaktDeviceConnection.switchToDeviceProfile((DeviceProfile)((Object)this.currentEntry.getValue()), nextWriteListener);
                break;
            }
            case "name": {
                this.kontaktDeviceConnection.overwriteModelName((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "password": {
                this.kontaktDeviceConnection.overwritePassword((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised tag: " + key);
            }
        }
    }

    private void performRollback(ProcessingListener processingListener) {
        this.batch.notifyProcessChanged();
        Iterator<Map.Entry<String, Object>> rollbackIterator = this.batch.rollbackIterator();
        if (rollbackIterator.hasNext()) {
            processingListener.onRollbackStart();
            this.processRollback(rollbackIterator, processingListener);
        }
    }

    void processRollback(final Iterator<Map.Entry<String, Object>> argumentIterator, final ProcessingListener processingListener) {
        WriteListener nextWriteListener = new WriteListener(){

            @Override
            public void onWriteSuccess(WriteListener.WriteResponse response) {
                if (argumentIterator.hasNext()) {
                    argumentIterator.remove();
                    KontaktDeviceBatchProcessor.this.processRollback(argumentIterator, processingListener);
                } else {
                    KontaktDeviceBatchProcessor.this.kontaktDeviceConnection.finishWriteBatch();
                    processingListener.onRollbackFinish();
                }
            }

            @Override
            public void onWriteFailure(ErrorCause cause) {
                Logger.d("Batch not fully applied. Next write operation is required.");
                KontaktDeviceBatchProcessor.this.kontaktDeviceConnection.finishWriteBatch();
                processingListener.onRollbackError(KontaktDeviceBatchProcessor.getErrorCode(KontaktDeviceBatchProcessor.this.currentEntry.getKey()));
            }
        };
        this.currentEntry = argumentIterator.next();
        String key = this.currentEntry.getKey();
        switch (this.currentEntry.getKey()) {
            case "proximity": {
                this.kontaktDeviceConnection.overwriteProximityUUID((UUID)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "interval": {
                this.kontaktDeviceConnection.overwriteAdvertisingInterval((Long)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "txPower": {
                this.kontaktDeviceConnection.overwritePowerLevel((Integer)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "major": {
                this.kontaktDeviceConnection.overwriteMajor((Integer)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "minor": {
                this.kontaktDeviceConnection.overwriteMinor((Integer)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "profiles": {
                this.kontaktDeviceConnection.switchToDeviceProfile((DeviceProfile)((Object)this.currentEntry.getValue()), nextWriteListener);
                break;
            }
            case "name": {
                this.kontaktDeviceConnection.overwriteModelName((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "namespace": {
                this.kontaktDeviceConnection.overwriteNamespaceId((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "instanceId": {
                this.kontaktDeviceConnection.overwriteInstanceId((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            case "url": {
                this.kontaktDeviceConnection.overwriteUrl((String)this.currentEntry.getValue(), nextWriteListener);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised tag: " + key);
            }
        }
    }

    static int getErrorCode(String key) {
        if (key.equals("interval")) {
            return 12;
        }
        if (key.equals("proximity")) {
            return 8;
        }
        if (key.equals("txPower")) {
            return 9;
        }
        if (key.equals("major")) {
            return 10;
        }
        if (key.equals("minor")) {
            return 11;
        }
        if (key.equals("profiles")) {
            return 13;
        }
        if (key.equals("namespace")) {
            return 14;
        }
        if (key.equals("instanceId")) {
            return 15;
        }
        if (key.equals("url")) {
            return 16;
        }
        if (key.equals("name")) {
            return 17;
        }
        if (key.equals("password")) {
            return 18;
        }
        throw new IllegalStateException("Unrecognised tag: " + key);
    }

    static class Batch {
        private final Map<String, Object> processArguments = new HashMap<String, Object>();
        private final Map<String, Object> rollbackArguments = new HashMap<String, Object>();

        Batch() {
        }

        void notifyProcessChanged() {
            this.rollbackArguments.entrySet().removeAll(this.processArguments.entrySet());
        }

        Iterator<Map.Entry<String, Object>> processIterator() {
            return this.processArguments.entrySet().iterator();
        }

        Iterator<Map.Entry<String, Object>> rollbackIterator() {
            return this.rollbackArguments.entrySet().iterator();
        }

        boolean isProcessEmpty() {
            return this.processArguments.isEmpty();
        }

        static Batch select(Config config, RemoteBluetoothDevice.Characteristics characteristics) {
            String devicePassword;
            int txPower;
            long interval;
            int minor;
            int major;
            List<DeviceProfile> deviceProfile;
            SDKPreconditions.checkNotNull(config, "Config is null");
            Batch batch = new Batch();
            String currentName = characteristics.getModelName();
            String desiredName = config.getName();
            if (!TextUtils.isEmpty((CharSequence)desiredName) && !currentName.equals(desiredName)) {
                batch.processArguments.put("name", desiredName);
                batch.rollbackArguments.put("name", currentName);
            }
            if ((deviceProfile = config.getProfiles()) != null && !deviceProfile.isEmpty()) {
                DeviceProfile desiredProfile = deviceProfile.get(0);
                DeviceProfile activeProfile = characteristics.getActiveProfile();
                if (activeProfile != null && desiredProfile != activeProfile) {
                    batch.processArguments.put("profiles", (Object)desiredProfile);
                    batch.rollbackArguments.put("profiles", (Object)activeProfile);
                }
            }
            UUID proximityUUID = config.getProximity();
            UUID characteristicProximityUUID = characteristics.getProximityUUID();
            if (proximityUUID != null && characteristicProximityUUID != null && !characteristics.getProximityUUID().equals(proximityUUID)) {
                batch.processArguments.put("proximity", proximityUUID);
                batch.rollbackArguments.put("proximity", characteristicProximityUUID);
            }
            if ((major = config.getMajor()) >= 0 && major != characteristics.getMajor() && characteristics.getMajor() > -1) {
                batch.processArguments.put("major", major);
                batch.rollbackArguments.put("major", characteristics.getMajor());
            }
            if ((minor = config.getMinor()) >= 0 && minor != characteristics.getMinor() && characteristics.getMinor() > -1) {
                batch.processArguments.put("minor", minor);
                batch.rollbackArguments.put("minor", characteristics.getMinor());
            }
            if ((interval = (long)config.getInterval()) != characteristics.getAdvertisingInterval() && interval > 0L) {
                batch.processArguments.put("interval", interval);
                batch.rollbackArguments.put("interval", characteristics.getAdvertisingInterval());
            }
            if ((txPower = config.getTxPower()) != characteristics.getPowerLevel() && txPower > -1) {
                batch.processArguments.put("txPower", txPower);
                batch.rollbackArguments.put("txPower", characteristics.getPowerLevel());
            }
            String namespace = config.getNamespace();
            String characteristicNamespace = characteristics.getNamespaceId();
            if (!TextUtils.isEmpty((CharSequence)namespace) && !TextUtils.equals((CharSequence)namespace, (CharSequence)characteristicNamespace)) {
                batch.processArguments.put("namespace", namespace);
                batch.rollbackArguments.put("namespace", characteristicNamespace);
            }
            String instanceId = config.getInstanceId();
            String characteristicInstanceId = characteristics.getInstanceId();
            if (!TextUtils.isEmpty((CharSequence)instanceId) && !TextUtils.equals((CharSequence)instanceId, (CharSequence)characteristicInstanceId)) {
                batch.processArguments.put("instanceId", instanceId);
                batch.rollbackArguments.put("instanceId", characteristicInstanceId);
            }
            String url = config.getUrl();
            String characteristicUrl = characteristics.getUrl();
            if (!TextUtils.isEmpty((CharSequence)url) && !TextUtils.equals((CharSequence)url, (CharSequence)characteristicUrl)) {
                batch.processArguments.put("url", url);
                batch.rollbackArguments.put("url", characteristicUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)(devicePassword = config.getPassword()))) {
                batch.processArguments.put("password", devicePassword);
            }
            return batch;
        }

        static Batch select(Preset profile, RemoteBluetoothDevice.Characteristics characteristics) {
            int txPower;
            SDKPreconditions.checkNotNull(profile, "Preset is null");
            Batch batch = new Batch();
            UUID proximityUUID = profile.getProximity();
            if (proximityUUID != null && !characteristics.getProximityUUID().equals(proximityUUID)) {
                batch.processArguments.put("proximity", proximityUUID);
                batch.rollbackArguments.put("proximity", proximityUUID);
            }
            long advertisingInterval = profile.getInterval();
            long currentInterval = characteristics.getAdvertisingInterval();
            if (currentInterval != advertisingInterval) {
                batch.processArguments.put("interval", advertisingInterval);
                batch.rollbackArguments.put("interval", advertisingInterval);
            }
            if ((txPower = profile.getTxPower()) != characteristics.getPowerLevel()) {
                batch.processArguments.put("txPower", txPower);
                batch.rollbackArguments.put("txPower", txPower);
            }
            return batch;
        }
    }

    static interface ProcessingListener {
        public void onStart();

        public void onError(int var1);

        public void onFinish();

        public void onRollbackStart();

        public void onRollbackFinish();

        public void onRollbackError(int var1);
    }
}

