package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.UrlRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

/**
 * Request executor designed for loading devices directly from the URL.
 */
public class DevicesFromUrlRequestExecutor extends UrlRequestExecutor<Devices> {

  private final DevicesService devicesService;

  /**
   * Constructs request executor initialized with corresponding service class and the URL.
   *
   * @param devicesService the devices API service.
   * @param url the URL.
   */
  public DevicesFromUrlRequestExecutor(final DevicesService devicesService, final String url) {
    super(url);
    this.devicesService = devicesService;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DevicesFromUrlRequestExecutor eTag(String eTag) {
    super.eTag(eTag);
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<Devices> prepareCall() {
    final Call<Devices> call;
    if (eTag != null) {
      call = devicesService.getDevicesFromUrl(url, eTag);
    } else {
      call = devicesService.getDevicesFromUrl(url);
    }
    return call;
  }

  @Override
  protected Map<String, String> params() {
    return new HashMap<>();
  }
}
