package com.kontakt.sdk.android.ble.manager.service;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.PermissionsUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * AbstractServiceConnector provides an abstraction to every Service. The abstraction
 * also validates required permissions specified when creating new ServiceConnector instance.
 */
public abstract class AbstractServiceConnector implements ServiceConnector {

  private static final String[] PERMISSIONS = new String[] {
      Manifest.permission.BLUETOOTH,
      Manifest.permission.BLUETOOTH_ADMIN,
      Manifest.permission.INTERNET,
  };

  private static final String[] PERMISSIONS_MARSHMALLOW = new String[] {
      Manifest.permission.ACCESS_FINE_LOCATION,
      Manifest.permission.ACCESS_COARSE_LOCATION
  };

  /**
   * The Context instance.
   */
  protected Context context;

  /**
   * Instantiates a new Abstract service connector.
   *
   * @param context the context
   */
  protected AbstractServiceConnector(final Context context) {
    SDKPreconditions.checkState(context != null, "Applied context instance is null");
    this.context = context.getApplicationContext();
  }

  @Override
  public void disconnect() {
    Logger.d(getClass().getSimpleName() + " disconnected.");
  }

  /**
   * Checks specific permissions under which Service connector works.
   */
  @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH_MR1)
  protected void checkPermissions() {
    PermissionsUtils.checkPermissions(context, PERMISSIONS);
    PermissionsUtils.checkAtLeastOneMarshmallowPermissionGranted(context, PERMISSIONS_MARSHMALLOW);
  }
}
