package com.kontakt.sdk.android.ble.manager;

import android.content.Context;

import com.kontakt.sdk.android.cloud.KontaktCloud;

/**
 * Factory class used to obtain {@link ProximityManager} instance.
 */
public class ProximityManagerFactory {

  /**
   * Creates new instance of {@link ProximityManager}.
   *
   * @param context {@link Context} instance.
   * @return new ProximityManager instance.
   */
  public static ProximityManager create(Context context) {
    return new ProximityManagerImpl(context);
  }

  public static ProximityManager create(Context context, KontaktCloud cloud) {
    return new ProximityManagerImpl(context, cloud);
  }

}
