package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.PropertyResolver;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystoneUtils;

final class URLResolver implements PropertyResolver<String> {

  private static final int SCAN_RECORD_EDDYSTONE_URL_START_INDEX = 4;

  @Override
  public String parse(byte[] packet) {
    if (packet == null) {
      return null;
    }

    final int urlLength = packet.length - SCAN_RECORD_EDDYSTONE_URL_START_INDEX;
    byte[] bytes = ConversionUtils.extractSubdata(packet, SCAN_RECORD_EDDYSTONE_URL_START_INDEX, urlLength);
    if (bytes == null) {
      return null;
    }

    return EddystoneUtils.deserializeUrl(bytes);
  }
}
