package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;

class EddystoneResolveRequest {
  private final IEddystoneDevice fakeDevice;
  private ResolverType resolvedBy = ResolverType.NONE;
  private ResolveRequestStatus status;

  public EddystoneResolveRequest(IEddystoneDevice eddystoneDevice) {
    this.fakeDevice = eddystoneDevice;
  }

  public IEddystoneDevice getFakeDevice() {
    return fakeDevice;
  }

  public ResolverType getResolvedBy() {
    return resolvedBy;
  }

  public void setResolvedBy(ResolverType resolvedBy) {
    this.resolvedBy = resolvedBy;
  }

  public void setStatus(ResolveRequestStatus status) {
    this.status = status;
  }

  public ResolveRequestStatus getStatus() {
    return status;
  }

  @Override
  public boolean equals(Object o) {
    if (o == null || !(o instanceof EddystoneResolveRequest)) {
      return false;
    }

    if (o == this) {
      return true;
    }

    EddystoneResolveRequest resolveRequest = (EddystoneResolveRequest) o;
    return SDKEqualsBuilder.start().equals(fakeDevice, resolveRequest.fakeDevice).equals(resolvedBy, resolveRequest.resolvedBy).result();
  }

  @Override
  public int hashCode() {
    return HashCodeBuilder.init().append(fakeDevice).append(resolvedBy).build();
  }

  static EddystoneResolveRequest of(RemoteBluetoothDevice device) {
    return new EddystoneResolveRequest((IEddystoneDevice) device);
  }
}
