/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Coordinates;
import com.kontakt.sdk.android.common.model.GeoCoordinates;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class Place
implements Parcelable {
    public static final Parcelable.Creator<Place> CREATOR = new Parcelable.Creator<Place>(){

        public Place createFromParcel(Parcel source) {
            return new Place(source);
        }

        public Place[] newArray(int size) {
            return new Place[size];
        }
    };
    private final UUID id;
    private final String name;
    private final UUID managerId;
    private final List<String> receiverIds;
    private final UUID venueId;
    private final UUID parentId;
    private final String schema;
    private final String schemaType;
    private final Coordinates coordinates;
    private final Coordinates geoCoordinates;
    private final double scale;

    public static Builder builder() {
        return new Builder();
    }

    private Place() {
        this(new Builder());
    }

    Place(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.managerId = builder.managerId;
        this.receiverIds = builder.receiverIds;
        this.venueId = builder.venueId;
        this.parentId = builder.parentId;
        this.schema = builder.schema;
        this.schemaType = builder.schemaType;
        this.coordinates = builder.coordinates;
        this.geoCoordinates = builder.geoCoordinates;
        this.scale = builder.scale;
    }

    protected Place(Parcel in) {
        this.id = (UUID)in.readSerializable();
        this.name = in.readString();
        this.managerId = (UUID)in.readSerializable();
        this.receiverIds = in.createStringArrayList();
        this.venueId = (UUID)in.readSerializable();
        this.parentId = (UUID)in.readSerializable();
        this.schema = in.readString();
        this.schemaType = in.readString();
        this.coordinates = (Coordinates)in.readParcelable(Coordinates.class.getClassLoader());
        this.geoCoordinates = (Coordinates)in.readParcelable(Coordinates.class.getClassLoader());
        this.scale = in.readDouble();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Place place = (Place)o;
        if (Double.compare(place.scale, this.scale) != 0) {
            return false;
        }
        if (this.id != null ? !this.id.equals(place.id) : place.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(place.name) : place.name != null) {
            return false;
        }
        if (this.managerId != null ? !this.managerId.equals(place.managerId) : place.managerId != null) {
            return false;
        }
        if (this.receiverIds != null ? !this.receiverIds.equals(place.receiverIds) : place.receiverIds != null) {
            return false;
        }
        if (this.venueId != null ? !this.venueId.equals(place.venueId) : place.venueId != null) {
            return false;
        }
        if (this.parentId != null ? !this.parentId.equals(place.parentId) : place.parentId != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(place.schema) : place.schema != null) {
            return false;
        }
        if (this.schemaType != null ? !this.schemaType.equals(place.schemaType) : place.schemaType != null) {
            return false;
        }
        if (this.coordinates != null ? !this.coordinates.equals(place.coordinates) : place.coordinates != null) {
            return false;
        }
        return this.geoCoordinates != null ? this.geoCoordinates.equals(place.geoCoordinates) : place.geoCoordinates == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.managerId != null ? this.managerId.hashCode() : 0);
        result = 31 * result + (this.receiverIds != null ? this.receiverIds.hashCode() : 0);
        result = 31 * result + (this.venueId != null ? this.venueId.hashCode() : 0);
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        result = 31 * result + (this.schemaType != null ? this.schemaType.hashCode() : 0);
        result = 31 * result + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        result = 31 * result + (this.geoCoordinates != null ? this.geoCoordinates.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.scale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.id);
        dest.writeString(this.name);
        dest.writeSerializable((Serializable)this.managerId);
        dest.writeStringList(this.receiverIds);
        dest.writeSerializable((Serializable)this.venueId);
        dest.writeSerializable((Serializable)this.parentId);
        dest.writeString(this.schema);
        dest.writeString(this.schemaType);
        dest.writeParcelable((Parcelable)this.coordinates, flags);
        dest.writeParcelable((Parcelable)this.geoCoordinates, flags);
        dest.writeDouble(this.scale);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public List<String> getReceiverIds() {
        return this.receiverIds;
    }

    public UUID getVenueId() {
        return this.venueId;
    }

    public UUID getParentId() {
        return this.parentId;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public GeoCoordinates getGeoCoordinates() {
        return (GeoCoordinates)this.geoCoordinates;
    }

    public double getScale() {
        return this.scale;
    }

    public static class Builder {
        UUID id;
        String name;
        UUID managerId;
        List<String> receiverIds = new ArrayList<String>();
        UUID venueId;
        UUID parentId;
        String schema;
        String schemaType;
        Coordinates coordinates;
        Coordinates geoCoordinates;
        double scale;

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder managerId(UUID managerId) {
            this.managerId = managerId;
            return this;
        }

        public Builder addReceiverIds(Collection<String> receiverIds) {
            SDKPreconditions.checkNotNull(receiverIds, "receiver IDs cannot be null");
            this.receiverIds.addAll(receiverIds);
            return this;
        }

        public Builder venueId(UUID venueId) {
            this.venueId = venueId;
            return this;
        }

        public Builder parentId(UUID parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder schemaType(String schemaType) {
            this.schemaType = schemaType;
            return this;
        }

        public Builder coordinates(Coordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Builder geoCoordinates(GeoCoordinates geoCoordinates) {
            this.geoCoordinates = geoCoordinates;
            return this;
        }

        public Builder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public Place build() {
            return new Place(this);
        }
    }
}

