/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.kontakt.sdk.android.common.log.LogLevel;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public final class KontaktSDK {
    public static final UUID DEFAULT_KONTAKT_BEACON_PROXIMITY_UUID = UUID.fromString("f7826da6-4fa2-4e98-8024-bc5b71e0893e");
    public static final String DEFAULT_KONTAKT_NAMESPACE_ID = "f7826da6bc5b71e0893e";
    private static KontaktSDK SINGLETON;
    private final String apiKey;

    private KontaktSDK(String apiKey) {
        this.apiKey = apiKey;
        Logger.reset();
    }

    public static synchronized KontaktSDK initialize(String apiKey) {
        SINGLETON = new KontaktSDK(apiKey);
        return SINGLETON;
    }

    public static synchronized KontaktSDK initialize(Context context) {
        ApplicationInfo appInfo;
        SDKPreconditions.checkNotNull(context, "Context can't be null");
        try {
            appInfo = context.getApplicationContext().getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException("Could not find application package name");
        }
        SDKPreconditions.checkArgument(appInfo != null, "Application info not found in the manifest. Please check your AndroidManifest.xml");
        SDKPreconditions.checkArgument(appInfo.metaData != null, "Meta data not found in the manifest. Please provide meta-data in the AndroidManifest.xml");
        String apiKey = appInfo.metaData.getString("kontakt.io.API_KEY");
        SDKPreconditions.checkArgument(!TextUtils.isEmpty((CharSequence)apiKey), "API key is not present. Please provide the key in the AndroidManifest.xml");
        return KontaktSDK.initialize(apiKey);
    }

    public static synchronized boolean isInitialized() {
        return SINGLETON != null;
    }

    public static synchronized KontaktSDK getInstance() {
        SDKPreconditions.checkNotNull(SINGLETON, "Kontakt.io SDK has not been initialized. Please, invoke initialize() method first");
        return SINGLETON;
    }

    public static synchronized void reset() {
        SINGLETON = null;
    }

    public final String getApiKey() {
        return this.apiKey;
    }

    public final KontaktSDK setDebugLoggingEnabled(boolean state) {
        Logger.setDebugLoggingEnabled(state);
        return this;
    }

    public final KontaktSDK setLogLevelEnabled(LogLevel level, boolean state) {
        Logger.setLogLevelEnabled(level, state);
        return this;
    }

    public final KontaktSDK setCrashlyticsLoggingEnabled(boolean state) {
        Logger.setCrashlyticsLoggingEnabled(state);
        return this;
    }
}

