/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.places;

import android.util.Base64;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PlacesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Place;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class CreatePlaceRequestExecutor
extends RequestExecutor<Place> {
    private final PlacesService placesService;
    private final Place place;
    private String encodedSchemaFile;

    public CreatePlaceRequestExecutor(PlacesService placesService, Place place) {
        this.placesService = placesService;
        this.place = place;
    }

    public CreatePlaceRequestExecutor withSchemaFile(File schemaFile) throws IOException {
        SDKPreconditions.checkNotNull(schemaFile, "schema file is null");
        SDKPreconditions.checkState(schemaFile.exists(), "schema file does not exist");
        byte[] bytes = ConversionUtils.convert(schemaFile);
        this.encodedSchemaFile = Base64.encodeToString((byte[])bytes, (int)0);
        return this;
    }

    @Override
    public Place execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Place)super.execute();
    }

    @Override
    public void execute(CloudCallback<Place> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Place> prepareCall() {
        return this.placesService.createPlace(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.place.getName() != null, "cannot create place - specify name");
        SDKPreconditions.checkState(this.place.getCoordinates() != null || this.place.getGeoCoordinates() != null, "cannot create place - specify either coordinates or geo coordinates");
        SDKPreconditions.checkState(this.place.getCoordinates() == null || this.place.getGeoCoordinates() == null, "cannot create place - both coordinates and geo coordinates cannot be specified");
        SDKPreconditions.checkState(this.place.getParentId() != null || this.place.getVenueId() != null, "cannot create place - either parent ID or venue ID must be set");
        if (this.place.getVenueId() != null) {
            SDKPreconditions.checkState(this.encodedSchemaFile != null, "cannot create place - schema file is required for root place");
        }
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.place.getName());
        params.put("scale", String.valueOf(this.place.getScale()));
        if (this.place.getCoordinates() != null) {
            params.put("coordinates", this.place.getCoordinates().toString());
        }
        if (this.place.getGeoCoordinates() != null) {
            params.put("geoCoordinates", this.place.getGeoCoordinates().toString());
        }
        if (this.encodedSchemaFile != null) {
            params.put("schema", this.encodedSchemaFile);
        }
        if (this.place.getParentId() != null) {
            params.put("parentId", this.place.getParentId().toString());
        }
        if (this.place.getVenueId() != null) {
            params.put("venueId", this.place.getVenueId().toString());
        }
        return params;
    }
}

