/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class ApplySecureConfigRequestExecutor
extends RequestExecutor<Configs> {
    private final DevicesService devicesService;
    private Config[] configs;

    public ApplySecureConfigRequestExecutor(DevicesService devicesService, Config ... configs) {
        this.devicesService = devicesService;
        this.configs = configs;
    }

    public ApplySecureConfigRequestExecutor(DevicesService devicesService, List<Config> configs) {
        this.devicesService = devicesService;
        int size = configs.size();
        this.configs = configs.toArray(new Config[size]);
    }

    @Override
    protected Call<Configs> prepareCall() {
        return this.devicesService.applySecureConfigs(this.params());
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", this.extractUniqueIds());
        params.put("response", this.extractResponses());
        params.put("updated", this.extractTimestamps());
        return params;
    }

    private String extractUniqueIds() {
        ArrayList<String> uniqueIds = new ArrayList<String>();
        for (Config config : this.configs) {
            SDKPreconditions.checkState(config.getUniqueId() != null, "config doesn't contain the unique ID");
            uniqueIds.add(config.getUniqueId());
        }
        return StringUtils.join(uniqueIds, ",");
    }

    private String extractResponses() {
        ArrayList<String> responses = new ArrayList<String>();
        for (Config config : this.configs) {
            SDKPreconditions.checkState(config.getSecureResponse() != null, "config doesn't contain the secure response");
            responses.add(config.getSecureResponse());
        }
        return StringUtils.join(responses, ",");
    }

    private String extractTimestamps() {
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (Config config : this.configs) {
            SDKPreconditions.checkState(config.getSecureResponseTime() != 0L, "config doesn't contain the secure response timestamp");
            timestamps.add(config.getSecureResponseTime());
        }
        return StringUtils.join(timestamps, ",");
    }
}

