/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.venues.CreateVenueRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.venues.DeleteVenueRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.venues.ShareVenueRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.venues.UnshareVenueRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.venues.UpdateVenueRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.venues.VenueImageRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.venues.VenueRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.venues.VenuesRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.UUID;

public class VenuesApi {
    private final VenuesService venuesService;

    public VenuesApi(VenuesService venuesService) {
        this.venuesService = venuesService;
    }

    public VenueRequestExecutor fetch(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new VenueRequestExecutor(this.venuesService, id);
    }

    public VenuesRequestExecutor fetch() {
        return new VenuesRequestExecutor(this.venuesService);
    }

    public VenueImageRequestExecutor imageOf(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new VenueImageRequestExecutor(this.venuesService, id);
    }

    public CreateVenueRequestExecutor create(Venue venue) {
        SDKPreconditions.checkNotNull(venue, "venue cannot be null");
        return new CreateVenueRequestExecutor(this.venuesService, venue);
    }

    public UpdateVenueRequestExecutor update(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new UpdateVenueRequestExecutor(this.venuesService, id);
    }

    public DeleteVenueRequestExecutor delete(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new DeleteVenueRequestExecutor(this.venuesService, id);
    }

    public ShareVenueRequestExecutor share(UUID ... ids) {
        SDKPreconditions.checkNotNull(ids, "IDs cannot be null");
        return new ShareVenueRequestExecutor(this.venuesService, ids);
    }

    public ShareVenueRequestExecutor share(List<UUID> ids) {
        SDKPreconditions.checkNotNull(ids, "IDs cannot be null");
        return new ShareVenueRequestExecutor(this.venuesService, ids);
    }

    public UnshareVenueRequestExecutor unshare(UUID ... ids) {
        SDKPreconditions.checkNotNull(ids, "IDs cannot be null");
        return new UnshareVenueRequestExecutor(this.venuesService, ids);
    }

    public UnshareVenueRequestExecutor unshare(List<UUID> ids) {
        SDKPreconditions.checkNotNull(ids, "IDs cannot be null");
        return new UnshareVenueRequestExecutor(this.venuesService, ids);
    }
}

