/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.places.CreatePlaceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.places.DeletePlaceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.places.PlaceSchemaImageRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.places.PlacesRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.places.UpdatePlaceRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PlacesService;
import com.kontakt.sdk.android.common.model.Place;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public class PlacesApi {
    private final PlacesService placesService;

    public PlacesApi(PlacesService placesService) {
        this.placesService = placesService;
    }

    public PlacesRequestExecutor fetch() {
        return new PlacesRequestExecutor(this.placesService);
    }

    public PlaceSchemaImageRequestExecutor schemaImageOf(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new PlaceSchemaImageRequestExecutor(this.placesService, id);
    }

    public CreatePlaceRequestExecutor create(Place place) {
        SDKPreconditions.checkNotNull(place, "place cannot be null");
        return new CreatePlaceRequestExecutor(this.placesService, place);
    }

    public UpdatePlaceRequestExecutor update(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new UpdatePlaceRequestExecutor(this.placesService, id);
    }

    public DeletePlaceRequestExecutor delete(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new DeletePlaceRequestExecutor(this.placesService, id);
    }
}

