/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.cloud.adapter.BaseTypeAdapter;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.Action;
import com.kontakt.sdk.android.common.model.ActionContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ActionTypeAdapter
extends BaseTypeAdapter<Action> {
    public void write(JsonWriter out, Action action) throws IOException {
        out = out.beginObject();
        this.writeUUID(out, "id", action.getId());
        this.writeEnum(out, "actionType", action.getType());
        this.writeEnum(out, "proximity", action.getProximity());
        this.writeString(out, "url", action.getUrl());
        this.writeContent(out, action.getContent());
        this.writeDevices(out, action.getDeviceUniqueIds());
        out.endObject();
    }

    public Action read(JsonReader in) throws IOException {
        Action.Builder actionBuilder = new Action.Builder();
        ActionContent.Builder actionContentBuilder = new ActionContent.Builder();
        in.beginObject();
        block24: while (in.hasNext()) {
            String fieldName = in.nextName();
            if (in.peek() == JsonToken.NULL) {
                in.skipValue();
                continue;
            }
            switch (fieldName) {
                case "id": {
                    UUID id = UUID.fromString(in.nextString());
                    actionBuilder.id(id);
                    continue block24;
                }
                case "actionType": {
                    Action.Type type = Action.Type.valueOf(in.nextString());
                    actionBuilder.actionType(type);
                    continue block24;
                }
                case "proximity": {
                    Proximity proximity = Proximity.valueOf(in.nextString());
                    actionBuilder.proximity(proximity);
                    continue block24;
                }
                case "url": {
                    String url = in.nextString();
                    actionBuilder.url(url);
                    continue block24;
                }
                case "deviceUniqueIds": {
                    List<String> deviceUniqueIds = this.readDevices(in);
                    actionBuilder.devices(deviceUniqueIds);
                    continue block24;
                }
                case "content": {
                    String content = in.nextString();
                    actionContentBuilder.content(content);
                    continue block24;
                }
                case "contentLength": {
                    int contentLength = in.nextInt();
                    actionContentBuilder.length(contentLength);
                    continue block24;
                }
                case "contentType": {
                    String contentType = in.nextString();
                    actionContentBuilder.type(contentType);
                    continue block24;
                }
                case "contentCategory": {
                    ActionContent.Category contentCategory = ActionContent.Category.valueOf(in.nextString());
                    actionContentBuilder.category(contentCategory);
                    continue block24;
                }
                case "conversionInProgress": {
                    boolean conversionInProgress = in.nextBoolean();
                    actionContentBuilder.conversionInProgress(conversionInProgress);
                    continue block24;
                }
            }
            in.skipValue();
        }
        in.endObject();
        actionBuilder.content(actionContentBuilder.build());
        return actionBuilder.build();
    }

    private void writeContent(JsonWriter out, ActionContent content) throws IOException {
        if (content == null) {
            return;
        }
        this.writeInteger(out, "contentLength", content.getLength());
        this.writeString(out, "contentType", content.getType());
        this.writeEnum(out, "contentCategory", content.getCategory());
        this.writeString(out, "content", content.getContentUrl());
        this.writeBoolean(out, "conversionInProgress", content.isConversionInProgress());
    }

    private void writeDevices(JsonWriter out, List<String> deviceUniqueIds) throws IOException {
        out.name("deviceUniqueIds");
        if (deviceUniqueIds == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (String uniqueId : deviceUniqueIds) {
            out.value(uniqueId);
        }
        out.endArray();
    }

    private List<String> readDevices(JsonReader in) throws IOException {
        in.beginArray();
        ArrayList<String> deviceUniqueIds = new ArrayList<String>();
        while (in.hasNext()) {
            deviceUniqueIds.add(in.nextString());
        }
        in.endArray();
        return deviceUniqueIds;
    }
}

