/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReplacingArrayList<T>
extends ArrayList<T> {
    private final Lock readLock;
    private final Lock writeLock;

    public ReplacingArrayList() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrReplace(T object) {
        try {
            this.writeLock.lock();
            int index = super.indexOf(object);
            if (index == -1) {
                boolean bl = super.add(object);
                return bl;
            }
            super.set(index, object);
            boolean bl = false;
            return bl;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.writeLock);
        }
    }

    @Override
    public int indexOf(Object object) {
        try {
            this.readLock.lock();
            int n = super.indexOf(object);
            return n;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.readLock);
        }
    }

    @Override
    public boolean add(T object) {
        try {
            this.writeLock.lock();
            boolean bl = super.add(object);
            return bl;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T object) {
        try {
            this.writeLock.lock();
            T t = super.set(index, object);
            return t;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.writeLock);
        }
    }

    @Override
    public boolean contains(Object object) {
        try {
            this.readLock.lock();
            boolean bl = super.contains(object);
            return bl;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        try {
            this.readLock.lock();
            Iterator<?> it = collection.iterator();
            while (it.hasNext()) {
                if (super.contains(it.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.readLock);
        }
    }

    @Override
    public T remove(int index) {
        try {
            this.writeLock.lock();
            Object e = super.remove(index);
            return (T)e;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.writeLock);
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        try {
            this.writeLock.lock();
            boolean bl = super.retainAll(collection);
            return bl;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        try {
            this.writeLock.lock();
            boolean result = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!collection.contains(it.next())) continue;
                it.remove();
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            ReplacingArrayList.unlockSafely(this.writeLock);
        }
    }

    private static void unlockSafely(Lock lock) {
        try {
            lock.unlock();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

