/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.TelemetryError;

public class KontaktTelemetry
implements Parcelable {
    public static final Parcelable.Creator<KontaktTelemetry> CREATOR = new Parcelable.Creator<KontaktTelemetry>(){

        public KontaktTelemetry createFromParcel(Parcel source) {
            return new KontaktTelemetry(source);
        }

        public KontaktTelemetry[] newArray(int size) {
            return new KontaktTelemetry[size];
        }
    };
    public static final int BATTERY_LEVEL_EXTERNAL_POWER_SUPPLIED_VALUE = 255;
    public static final int DOUBLE_TAP_DISABLED_VALUE = 65535;
    public static final int THRESHOLD_DISABLED_VALUE = 65535;
    public static final int LOAD_AVERAGE_NOT_SUPPORTED_VALUE = 255;
    public static final int BLE_SCANS_NOT_SUPPORTED_VALUE = 255;
    public static final int WIFI_SCANS_NOT_SUPPORTED_VALUE = 255;
    public static final int BLE_DEVICES_NOT_SUPPORTED_VALUE = 65535;
    private final int timestamp;
    private final int batteryLevel;
    private final int uptime;
    private final int systemLoad;
    private final TelemetryError error;
    private final int sensitivity;
    private final Acceleration acceleration;
    private final int lastDoubleTap;
    private final int lastThreshold;
    private final int lightSensor;
    private final int temperature;
    private final int bleScans;
    private final int wifiScans;
    private final int bleDevices;

    private KontaktTelemetry(Builder builder) {
        this.timestamp = builder.timestamp;
        this.batteryLevel = builder.batteryLevel;
        this.uptime = builder.uptime;
        this.systemLoad = builder.systemLoad;
        this.error = builder.error;
        this.sensitivity = builder.sensitivity;
        this.acceleration = builder.acceleration;
        this.lastDoubleTap = builder.lastDoubleTap;
        this.lastThreshold = builder.lastThreshold;
        this.lightSensor = builder.lightSensor;
        this.temperature = builder.temperature;
        this.bleScans = builder.bleScans;
        this.wifiScans = builder.wifiScans;
        this.bleDevices = builder.bleDevices;
    }

    protected KontaktTelemetry(Parcel in) {
        this.timestamp = in.readInt();
        this.batteryLevel = in.readInt();
        this.uptime = in.readInt();
        this.systemLoad = in.readInt();
        int tmpError = in.readInt();
        this.error = tmpError == -1 ? null : TelemetryError.values()[tmpError];
        this.sensitivity = in.readInt();
        this.acceleration = (Acceleration)in.readParcelable(Acceleration.class.getClassLoader());
        this.lastDoubleTap = in.readInt();
        this.lastThreshold = in.readInt();
        this.lightSensor = in.readInt();
        this.temperature = in.readInt();
        this.bleScans = in.readInt();
        this.wifiScans = in.readInt();
        this.bleDevices = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KontaktTelemetry that = (KontaktTelemetry)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.batteryLevel != that.batteryLevel) {
            return false;
        }
        if (this.uptime != that.uptime) {
            return false;
        }
        if (this.systemLoad != that.systemLoad) {
            return false;
        }
        if (this.sensitivity != that.sensitivity) {
            return false;
        }
        if (this.lastDoubleTap != that.lastDoubleTap) {
            return false;
        }
        if (this.lastThreshold != that.lastThreshold) {
            return false;
        }
        if (this.lightSensor != that.lightSensor) {
            return false;
        }
        if (this.temperature != that.temperature) {
            return false;
        }
        if (this.bleScans != that.bleScans) {
            return false;
        }
        if (this.wifiScans != that.wifiScans) {
            return false;
        }
        if (this.bleDevices != that.bleDevices) {
            return false;
        }
        if (this.error != that.error) {
            return false;
        }
        return this.acceleration != null ? this.acceleration.equals(that.acceleration) : that.acceleration == null;
    }

    public int hashCode() {
        int result = this.timestamp;
        result = 31 * result + this.batteryLevel;
        result = 31 * result + this.uptime;
        result = 31 * result + this.systemLoad;
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + this.sensitivity;
        result = 31 * result + (this.acceleration != null ? this.acceleration.hashCode() : 0);
        result = 31 * result + this.lastDoubleTap;
        result = 31 * result + this.lastThreshold;
        result = 31 * result + this.lightSensor;
        result = 31 * result + this.temperature;
        result = 31 * result + this.bleScans;
        result = 31 * result + this.wifiScans;
        result = 31 * result + this.bleDevices;
        return result;
    }

    public String toString() {
        return "KontaktTelemetry{timestamp=" + this.timestamp + ", batteryLevel=" + this.batteryLevel + ", uptime=" + this.uptime + ", systemLoad=" + this.systemLoad + ", error=" + (Object)((Object)this.error) + ", sensitivity=" + this.sensitivity + ", acceleration=" + this.acceleration + ", lastDoubleTap=" + this.lastDoubleTap + ", lastThreshold=" + this.lastThreshold + ", lightSensor=" + this.lightSensor + ", temperature=" + this.temperature + ", bleScans=" + this.bleScans + ", wifiScans=" + this.wifiScans + ", bleDevices=" + this.bleDevices + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.timestamp);
        dest.writeInt(this.batteryLevel);
        dest.writeInt(this.uptime);
        dest.writeInt(this.systemLoad);
        dest.writeInt(this.error == null ? -1 : this.error.ordinal());
        dest.writeInt(this.sensitivity);
        dest.writeParcelable((Parcelable)this.acceleration, flags);
        dest.writeInt(this.lastDoubleTap);
        dest.writeInt(this.lastThreshold);
        dest.writeInt(this.lightSensor);
        dest.writeInt(this.temperature);
        dest.writeInt(this.bleScans);
        dest.writeInt(this.wifiScans);
        dest.writeInt(this.bleDevices);
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public int getUptime() {
        return this.uptime;
    }

    public int getSystemLoad() {
        return this.systemLoad;
    }

    public TelemetryError getError() {
        return this.error;
    }

    public int getSensitivity() {
        return this.sensitivity;
    }

    public Acceleration getAcceleration() {
        return this.acceleration;
    }

    public int getLastDoubleTap() {
        return this.lastDoubleTap;
    }

    public int getLastThreshold() {
        return this.lastThreshold;
    }

    public int getLightSensor() {
        return this.lightSensor;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getBleScans() {
        return this.bleScans;
    }

    public int getWifiScans() {
        return this.wifiScans;
    }

    public int getBleDevices() {
        return this.bleDevices;
    }

    public static class Builder {
        private int timestamp;
        private int batteryLevel;
        private int uptime;
        private int systemLoad;
        private TelemetryError error;
        private int sensitivity;
        private Acceleration acceleration;
        private int lastDoubleTap;
        private int lastThreshold;
        private int lightSensor;
        private int temperature;
        private int bleScans;
        private int wifiScans;
        private int bleDevices;

        public Builder timestamp(int timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder batteryLevel(int batteryLevel) {
            this.batteryLevel = batteryLevel;
            return this;
        }

        public Builder uptime(int uptime) {
            this.uptime = uptime;
            return this;
        }

        public Builder systemLoad(int systemLoad) {
            this.systemLoad = systemLoad;
            return this;
        }

        public Builder error(TelemetryError error) {
            this.error = error;
            return this;
        }

        public Builder sensitivity(int sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        public Builder acceleration(Acceleration acceleration) {
            this.acceleration = acceleration;
            return this;
        }

        public Builder lastDoubleTap(int lastDoubleTap) {
            this.lastDoubleTap = lastDoubleTap;
            return this;
        }

        public Builder lastThreshold(int lastThreshold) {
            this.lastThreshold = lastThreshold;
            return this;
        }

        public Builder lightSensor(int lightSensor) {
            this.lightSensor = lightSensor;
            return this;
        }

        public Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder bleScans(int bleScans) {
            this.bleScans = bleScans;
            return this;
        }

        public Builder wifiScans(int wifiScans) {
            this.wifiScans = wifiScans;
            return this;
        }

        public Builder bleDevices(int bleDevices) {
            this.bleDevices = bleDevices;
            return this;
        }

        public KontaktTelemetry build() {
            return new KontaktTelemetry(this);
        }
    }
}

