/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.ScanCompat;
import com.kontakt.sdk.android.ble.service.ScanCompatFactory;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanController;
import com.kontakt.sdk.android.ble.service.ServiceScanConfiguration;
import com.kontakt.sdk.android.common.interfaces.SDKSupplier;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.Closeables;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class ProximityService
extends Service {
    static final String TAG = ProximityService.class.getSimpleName();
    public static final int MESSAGE_INITIALIZE_SCAN = 1;
    public static final int MESSAGE_RESTART_SCAN = 2;
    public static final int MESSAGE_FINISH_SCAN = 3;
    public static final int MESSAGE_ATTACH_MONITORING_LISTENER = 4;
    public static final int MESSAGE_DETACH_MONITORING_LISTENER = 5;
    public static final int MESSAGE_WORK_FINISHED = 6;
    public static final int MESSAGE_SERVICE_RESPONSE_OK = 200;
    private final ServiceScanConfiguration configuration = new ServiceScanConfiguration();
    private Messenger serviceMessenger;
    private ServiceBinder serviceBinder;
    private Handler messagingHandler;
    private ScanCompat scanCompat;

    public void onCreate() {
        super.onCreate();
        this.messagingHandler = new MessagingHandler(this);
        this.serviceMessenger = new Messenger(this.messagingHandler);
        this.serviceBinder = new ServiceBinder(this.serviceMessenger);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return this.serviceBinder;
    }

    public void onDestroy() {
        super.onDestroy();
        this.configuration.clear();
        this.messagingHandler = null;
        this.serviceMessenger = null;
    }

    public final Handler getMessagingHandler() {
        return this.messagingHandler;
    }

    ServiceScanConfiguration getConfiguration() {
        return this.configuration;
    }

    void onStartScan(Bundle bundle) {
        ScanContext scanContext = bundle.getScanContext();
        FutureShufflesCache shufflesCache = bundle.getShufflesCache();
        IEventCollector eventCollector = bundle.getEventCollector();
        this.createScanCompat();
        this.onStopScan();
        ScanConfiguration previousConfiguration = this.configuration.getScanConfiguration();
        ScanConfiguration newConfiguration = this.scanCompat.createScanConfiguration(scanContext, shufflesCache, eventCollector);
        Closeables.closeQuietly(previousConfiguration);
        ForceScanScheduler forceScanScheduler = this.scanCompat.createForceScanScheduler(newConfiguration);
        ScanController scanController = this.scanCompat.createScanController(newConfiguration, forceScanScheduler);
        ServiceScanConfiguration.Item item = new ServiceScanConfiguration.Item(newConfiguration, forceScanScheduler, scanController);
        this.configuration.add(item);
        this.configuration.getScanController().start();
        this.scanCompat.onScanStart(this.configuration.getScanConfiguration());
        this.updateState(State.SCANNING);
    }

    void onStopScan() {
        if (this.isScanning()) {
            this.createScanCompat();
            this.configuration.getScanController().stop();
            this.scanCompat.onScanStop(this.configuration.getScanConfiguration().getScanCallback());
            this.configuration.getForceScanScheduler().stop();
            this.updateState(State.IDLE);
        } else {
            Logger.d(TAG + ": Stop Ranging method requested but BeaconService is not is Ranging state.");
        }
    }

    void onAttachListener(InternalProximityListener proximityListener) {
        this.configuration.addListener(proximityListener);
    }

    void onDetachListener(InternalProximityListener proximityListener) {
        this.configuration.removeListener(proximityListener);
    }

    protected boolean isScanning() {
        return this.configuration.getState() == State.SCANNING;
    }

    protected void updateState(State newState) {
        this.configuration.updateState(newState);
    }

    void onCleanUp() {
        ServiceScanConfiguration.Item item = this.configuration.remove();
        Closeables.closeQuietly(item.scanConfiguration);
        ForceScanScheduler forceScanScheduler = item.forceScanScheduler;
        if (forceScanScheduler != null) {
            forceScanScheduler.finish();
        }
        item.scanController.stop();
    }

    private void createScanCompat() {
        if (this.scanCompat == null) {
            this.scanCompat = ScanCompatFactory.createScanCompat();
        }
    }

    static enum State {
        IDLE,
        SCANNING;

    }

    public static final class Bundle {
        private final ScanContext scanContext;
        private final FutureShufflesCache shufflesCache;
        private final IEventCollector eventCollector;

        public Bundle(ScanContext scanContext, FutureShufflesCache shufflesCache, IEventCollector eventCollector) {
            this.scanContext = SDKPreconditions.checkNotNull(scanContext);
            this.shufflesCache = SDKPreconditions.checkNotNull(shufflesCache);
            this.eventCollector = SDKPreconditions.checkNotNull(eventCollector);
        }

        public ScanContext getScanContext() {
            return this.scanContext;
        }

        public FutureShufflesCache getShufflesCache() {
            return this.shufflesCache;
        }

        IEventCollector getEventCollector() {
            return this.eventCollector;
        }
    }

    private static final class MessagingHandler
    extends Handler {
        private final ProximityService service;

        MessagingHandler(ProximityService abstractBluetoothDeviceService) {
            this.service = abstractBluetoothDeviceService;
        }

        public void handleMessage(Message msg) {
            try {
                Logger.d(TAG + " Message received.");
                switch (msg.what) {
                    case 1: {
                        Logger.d(TAG + " MESSAGE_INITIALIZE_SCAN");
                        this.service.onStartScan((Bundle)msg.obj);
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)200, (int)0));
                        break;
                    }
                    case 3: {
                        Logger.d(TAG + " MESSAGE_FINISH_SCAN");
                        this.service.onStopScan();
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)200, (int)0));
                        break;
                    }
                    case 2: {
                        Logger.d(TAG + " MESSAGE_RESTART_SCAN");
                        this.service.onStopScan();
                        this.service.onStartScan((Bundle)msg.obj);
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)200, (int)0));
                        break;
                    }
                    case 6: {
                        Logger.d(TAG + " MESSAGE_WORK_FINISHED");
                        this.service.onCleanUp();
                        this.service.stopSelf();
                        msg.replyTo.send(Message.obtain(null, (int)msg.what, (int)200, (int)0));
                        break;
                    }
                    case 4: {
                        Logger.d(TAG + " MESSAGE_ATTACH_MONITORING_LISTENER");
                        this.service.onAttachListener((InternalProximityListener)msg.obj);
                        break;
                    }
                    case 5: {
                        Logger.d(TAG + " MESSAGE_DETACH_MONITORING_LISTENER");
                        this.service.onDetachListener((InternalProximityListener)msg.obj);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported message code: " + msg.what);
                    }
                }
            }
            catch (Exception ignored) {
                Logger.e(TAG + " " + ignored.getMessage());
            }
        }
    }

    private static final class ServiceBinder
    extends Binder
    implements SDKSupplier<Messenger> {
        private final Messenger serviceMessenger;

        ServiceBinder(Messenger serviceMessenger) {
            this.serviceMessenger = serviceMessenger;
        }

        @Override
        public Messenger get() {
            return this.serviceMessenger;
        }
    }
}

