/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.ListenerAccessor;
import com.kontakt.sdk.android.ble.service.ListenerCollector;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=18)
interface BleScanCallback
extends BluetoothAdapter.LeScanCallback,
ListenerCollector,
ListenerAccessor,
Closeable {
    public static final BleScanCallback DEFAULT = new BleScanCallback(){
        private final ConcurrentHashMap<Integer, InternalProximityListener> monitoringListenerMap = new ConcurrentHashMap();

        @Override
        public Collection<InternalProximityListener> getMonitoringListeners() {
            return Collections.unmodifiableCollection(new ArrayList<InternalProximityListener>(this.monitoringListenerMap.values()));
        }

        @Override
        public void addListener(InternalProximityListener proximityListener) {
            this.monitoringListenerMap.put(System.identityHashCode(proximityListener), proximityListener);
        }

        @Override
        public void removeListener(InternalProximityListener proximityListener) {
            this.monitoringListenerMap.remove(System.identityHashCode(proximityListener), proximityListener);
        }

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        }

        @Override
        public void close() throws IOException {
            this.monitoringListenerMap.clear();
        }
    };
}

