/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.ble.filter.ibeacon.DeviceNameFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.FirmwareFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconMultiFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconUniqueIdFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.MajorFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.MinorFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.ProximityUUIDFilter;
import java.util.UUID;

public final class IBeaconFilters {
    private IBeaconFilters() {
    }

    public static ProximityUUIDFilter newProximityUUIDFilter(UUID proximityUUID) {
        return new ProximityUUIDFilter(proximityUUID);
    }

    public static IBeaconUniqueIdFilter newUniqueIdFilter(String beaconUniqueId) {
        return new IBeaconUniqueIdFilter(beaconUniqueId);
    }

    public static DeviceNameFilter newDeviceNameFilter(String beaconName) {
        return new DeviceNameFilter(beaconName);
    }

    public static FirmwareFilter newFirmwareFilter(String firmwareVersion) {
        return new FirmwareFilter(firmwareVersion);
    }

    public static MajorFilter newMajorFilter(int major) {
        return new MajorFilter(major);
    }

    public static MinorFilter newMinorFilter(int minor) {
        return new MinorFilter(minor);
    }

    public static IBeaconMultiFilter.Builder newMultiFilterBuilder() {
        return new IBeaconMultiFilter.Builder();
    }
}

