/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.discovery.PropertyResolver;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.ble.spec.TelemetryError;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class KontaktTLMResolver
implements PropertyResolver<KontaktTelemetry> {
    private static final byte BASIC_SYSTEM_HEALTH_IDENTIFIER = 1;
    private static final byte ACCELEROMETER_IDENTIFIER = 2;
    private static final byte SCANNING_IDENTIFIER = 3;
    private static final byte MORE_SYSTEM_HEALTH_IDENTIFIER = 4;
    private static final byte SENSORS_IDENTIFIER = 5;
    private static final int BASIC_SYSTEM_HEALTH_FIELD_LENGTH = 6;
    private static final int ACCELEROMETER_FIELD_LENGTH = 9;
    private static final int SCANNING_FIELD_LENGTH = 5;
    private static final int MORE_SYSTEM_HEALTH_FIELD_LENGTH = 10;
    private static final int SENSORS_FIELD_LENGTH = 3;
    private static final int FIELDS_PAYLOAD_OFFSET = 3;

    KontaktTLMResolver() {
    }

    @Override
    public KontaktTelemetry parse(byte[] packet) {
        int fieldLength;
        byte[] field;
        if (packet == null || packet.length == 0) {
            return null;
        }
        KontaktTelemetry.Builder builder = new KontaktTelemetry.Builder();
        byte[] fieldsData = ConversionUtils.extractSubdata(packet, 3, packet.length - 3);
        while (fieldsData != null && fieldsData.length > 0 && (field = ConversionUtils.extractSubdata(fieldsData, 1, fieldLength = ConversionUtils.asInt(fieldsData[0]))) != null) {
            byte identifier = field[0];
            if (identifier == 1 && field.length >= 6) {
                this.resolveBasicSystemHealth(builder, field);
            }
            if (identifier == 2 && field.length >= 9) {
                this.resolveAccelerometerData(builder, field);
            }
            if (identifier == 3 && field.length >= 5) {
                this.resolveScanningData(builder, field);
            }
            if (identifier == 4 && field.length >= 10) {
                this.resolveMoreSystemHealth(builder, field);
            }
            if (identifier == 5 && field.length >= 3) {
                this.resolveSensors(builder, field);
            }
            fieldsData = ConversionUtils.extractSubdata(fieldsData, field.length + 1, fieldsData.length - (field.length + 1));
        }
        return builder.build();
    }

    private void resolveBasicSystemHealth(KontaktTelemetry.Builder builder, byte[] field) {
        int timestamp = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 4));
        builder.timestamp(timestamp);
        int batteryLevel = ConversionUtils.asInt(field[5]);
        builder.batteryLevel(batteryLevel);
    }

    private void resolveAccelerometerData(KontaktTelemetry.Builder builder, byte[] field) {
        int sensitivity = ConversionUtils.asInt(field[1]);
        builder.sensitivity(sensitivity);
        Acceleration acceleration = new Acceleration(ConversionUtils.extractSubdata(field, 2, 3));
        builder.acceleration(acceleration);
        int lastDoubleTap = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 5, 2));
        builder.lastDoubleTap(lastDoubleTap);
        int lastThreshold = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 7, 2));
        builder.lastThreshold(lastThreshold);
    }

    private void resolveScanningData(KontaktTelemetry.Builder builder, byte[] field) {
        int bleScans = ConversionUtils.asInt(field[1]);
        builder.bleScans(bleScans);
        int wifiScans = ConversionUtils.asInt(field[2]);
        builder.wifiScans(wifiScans);
        int bleDevices = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 3, 2));
        builder.bleDevices(bleDevices);
    }

    private void resolveMoreSystemHealth(KontaktTelemetry.Builder builder, byte[] field) {
        int timestamp = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 4));
        builder.timestamp(timestamp);
        int uptime = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 5, 2));
        builder.uptime(uptime);
        int systemLoad = ConversionUtils.asInt(field[7]);
        builder.systemLoad(systemLoad);
        TelemetryError error = TelemetryError.fromValue(ConversionUtils.asInt(ConversionUtils.extractSubdata(field, 8, 2)));
        builder.error(error);
    }

    private void resolveSensors(KontaktTelemetry.Builder builder, byte[] field) {
        int lightSensor = ConversionUtils.asInt(field[1]);
        builder.lightSensor(lightSensor);
        byte temperature = field[2];
        builder.temperature(temperature);
    }
}

