/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.device.BeaconDevice;
import com.kontakt.sdk.android.ble.discovery.DiscoveryUtils;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.Parser;
import com.kontakt.sdk.android.ble.discovery.ScanResponse;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;

public final class IBeaconParser
extends Parser<BeaconDevice> {
    public static final byte[] MANUFACTURER_DATA_IBEACON_PREFIX = new byte[]{76, 0, 2, 21};
    private static final int MANUFACTURER_DATA_IBEACON_LENGTH = 25;
    private final Set<IBeaconRegion> regions;

    public IBeaconParser(ScanContext scanContext) {
        super(scanContext);
        this.regions = scanContext.getIBeaconRegions();
    }

    public void parseScanRecord(byte[] scanRecord) {
        this.frameData.clear();
        this.extractFrameData(scanRecord, this.frameData);
    }

    boolean isValidIBeaconFrame(byte[] scanRecord) {
        return ConversionUtils.doesArrayContainSubset(scanRecord, MANUFACTURER_DATA_IBEACON_PREFIX, 5);
    }

    boolean isManufacturerDataValid() {
        byte[] manufacturerData = (byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA);
        return manufacturerData != null && manufacturerData.length == 25;
    }

    IBeaconDevice getIBeaconDevice(BluetoothDevice device, int rssi) {
        int deviceHashCode = this.hashCodeBuilder.append(device.getAddress()).append((byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA)).build();
        BeaconDevice iBeaconDevice = (BeaconDevice)this.devicesCache.get(deviceHashCode);
        if (iBeaconDevice != null) {
            this.update(iBeaconDevice, deviceHashCode, rssi);
            return new BeaconDevice.Builder(iBeaconDevice).build();
        }
        byte[] manufacturerData = (byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA);
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        ScanResponse scanResponse = ScanResponse.fromScanResponseBytes(serviceData);
        UUID proximityUUID = ConversionUtils.toUUID(Arrays.copyOfRange(manufacturerData, 4, 20));
        int major = ConversionUtils.asInt(Arrays.copyOfRange(manufacturerData, 20, 22));
        int minor = ConversionUtils.asInt(Arrays.copyOfRange(manufacturerData, 22, 24));
        int calculatedRssi = this.rssiCalculator.calculateRssi(device.getAddress().hashCode(), rssi);
        byte txPower = manufacturerData[24];
        double distance = DiscoveryUtils.calculateDistance(txPower, calculatedRssi, DeviceProfile.IBEACON);
        iBeaconDevice = new BeaconDevice.Builder().address(device.getAddress()).uniqueId(scanResponse.getUniqueId()).batteryPower(scanResponse.getBatteryPower()).firmwareRevision(scanResponse.getFirmwareVersion()).shuffled(this.isShuffled(scanResponse, proximityUUID)).name(device.getName()).proximityUUID(proximityUUID).major(major).minor(minor).distance(distance).proximity(Proximity.fromDistance(distance)).txPower(txPower).timestamp(System.currentTimeMillis()).rssi(calculatedRssi).build();
        this.devicesCache.put(deviceHashCode, iBeaconDevice);
        return new BeaconDevice.Builder(iBeaconDevice).build();
    }

    private void update(BeaconDevice device, int deviceHashCode, int rssi) {
        int calculatedRssi = this.rssiCalculator.calculateRssi(deviceHashCode, rssi);
        byte txPower = ((byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA))[24];
        double distance = DiscoveryUtils.calculateDistance(txPower, calculatedRssi, DeviceProfile.IBEACON);
        device.setDistance(distance);
        device.setRssi(calculatedRssi);
        device.setProximity(Proximity.fromDistance(distance));
        device.setTimestamp(System.currentTimeMillis());
    }

    private boolean isShuffled(ScanResponse scanResponse, UUID proximityUUID) {
        return scanResponse.isUnknown() ? this.isSecureRegionDefined(proximityUUID) : scanResponse.isShuffled();
    }

    private boolean isSecureRegionDefined(UUID proximityUUID) {
        for (IBeaconRegion region : this.regions) {
            if (region.getSecureProximity() == null || !proximityUUID.equals(region.getSecureProximity())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
            this.devicesCache.clear();
            this.rssiCalculator.clear();
        }
    }
}

