/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.discovery.AbstractDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconParser;
import com.kontakt.sdk.android.ble.discovery.ibeacon.RegionValidator;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.List;

public class IBeaconDiscoverer
extends AbstractDeviceDiscoverer<IBeaconRegion, IBeaconDevice, IBeaconFilter> {
    private final Validator<IBeaconDevice, IBeaconRegion> validator = new RegionValidator();
    private final IBeaconParser parser;

    public IBeaconDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract, FutureShufflesCache cache) {
        super(discoveryContract, scanContext, scanContext.getIBeaconRegions(), scanContext.getIBeaconFilters(), cache);
        this.parser = new IBeaconParser(scanContext);
    }

    @Override
    protected BluetoothDeviceEvent createEvent(EventType eventType, IBeaconRegion iBeaconRegion, List<IBeaconDevice> deviceList) {
        return new IBeaconDeviceEvent(eventType, iBeaconRegion, deviceList);
    }

    @Override
    protected void onBeforeDeviceLost(IBeaconDevice device) {
        this.parser.clearRssiCalculation(device.getAddress().hashCode());
    }

    @Override
    public void performDiscovery(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (!this.parser.isEnabled() || !this.parser.isValidIBeaconFrame(scanRecord)) {
            return;
        }
        this.parser.parseScanRecord(scanRecord);
        if (this.parser.getFrameData().size() == 0 || !this.parser.isManufacturerDataValid()) {
            return;
        }
        IBeaconDevice iBeaconDevice = this.parser.getIBeaconDevice(device, rssi);
        this.notifyDevicePresent(device.getAddress().hashCode(), System.currentTimeMillis());
        if (iBeaconDevice.isShuffled()) {
            this.resolveShuffled(iBeaconDevice);
        } else {
            this.onShuffleResolved(iBeaconDevice);
        }
    }

    @Override
    protected void onShuffleResolved(RemoteBluetoothDevice device) {
        if (!(device instanceof IBeaconDevice)) {
            return;
        }
        IBeaconDevice iBeaconDevice = (IBeaconDevice)device;
        IBeaconRegion iBeaconRegion = this.extractRegion(iBeaconDevice);
        if (iBeaconRegion == null) {
            return;
        }
        if (device.getProximity() != Proximity.UNKNOWN) {
            this.notifySpacePresent(iBeaconRegion.hashCode(), System.currentTimeMillis());
            ReplacingArrayList<Object> iBeaconList = this.getDevicesInSpace(iBeaconRegion);
            if (iBeaconList == null) {
                iBeaconList = new ReplacingArrayList();
                this.insertDevicesIntoSpace(iBeaconRegion, iBeaconList);
                this.onSpaceEnteredEvent(iBeaconRegion);
            }
            if (!this.applyFilters(iBeaconDevice)) {
                return;
            }
            if (iBeaconList.addOrReplace(iBeaconDevice)) {
                this.onDeviceDiscoveredEvent(iBeaconRegion, iBeaconDevice);
            } else {
                this.onDevicesUpdatedEvent(iBeaconRegion, iBeaconList);
            }
        }
    }

    private IBeaconRegion extractRegion(IBeaconDevice iBeaconDevice) {
        for (IBeaconRegion iBeaconRegion : this.getSpaceSet()) {
            if (!this.validator.isValid(iBeaconDevice, iBeaconRegion)) continue;
            return iBeaconRegion;
        }
        return null;
    }

    @Override
    public void disable() {
        this.parser.disable();
        super.disable();
    }
}

