/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.discovery.AbstractDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneParser;
import com.kontakt.sdk.android.ble.discovery.eddystone.NamespaceValidator;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.List;

public class EddystoneDiscoverer
extends AbstractDeviceDiscoverer<IEddystoneNamespace, IEddystoneDevice, EddystoneFilter> {
    private final Validator<IEddystoneDevice, IEddystoneNamespace> validator = new NamespaceValidator();
    private final EddystoneParser parser;

    public EddystoneDiscoverer(DiscoveryContract discoveryContract, ScanContext scanContext, FutureShufflesCache shufflesCache) {
        super(discoveryContract, scanContext, scanContext.getEddystoneNamespaces(), scanContext.getEddystoneFilters(), shufflesCache);
        this.parser = new EddystoneParser(scanContext);
    }

    @Override
    protected BluetoothDeviceEvent createEvent(EventType eventType, IEddystoneNamespace eddystoneNamespace, List<IEddystoneDevice> deviceList) {
        return new EddystoneDeviceEvent(eventType, eddystoneNamespace, deviceList);
    }

    @Override
    protected void onBeforeDeviceLost(IEddystoneDevice device) {
        this.parser.clearRssiCalculation(device.getAddress().hashCode());
    }

    @Override
    public void performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanRecord) {
        String deviceAddress = bluetoothDevice.getAddress();
        if (this.parser.isEnabled() && !this.parser.isValidEddystoneFrame(scanRecord)) {
            return;
        }
        EddystoneFrameType frameType = EddystoneFrameType.fromScanRecord(scanRecord);
        if (frameType == null) {
            return;
        }
        boolean frameParsed = this.parser.parseFrame(frameType, deviceAddress, scanRecord);
        if (!frameParsed) {
            return;
        }
        this.notifyDevicePresent(deviceAddress.hashCode(), System.currentTimeMillis());
        if (!this.parser.areTriggerFramesParsed(deviceAddress)) {
            return;
        }
        IEddystoneDevice device = this.parser.getEddystoneDevice(bluetoothDevice, rssi);
        if (device.isShuffled()) {
            this.resolveShuffled(device);
        } else {
            this.onShuffleResolved(device);
        }
    }

    @Override
    protected void onShuffleResolved(RemoteBluetoothDevice device) {
        if (!(device instanceof IEddystoneDevice)) {
            return;
        }
        IEddystoneDevice eddystoneDevice = (IEddystoneDevice)device;
        IEddystoneNamespace namespace = this.extractNamespace(eddystoneDevice);
        if (namespace == null && this.getSpaceSet().contains(EddystoneNamespace.EVERYWHERE)) {
            namespace = EddystoneNamespace.EVERYWHERE;
        } else if (namespace == null) {
            return;
        }
        this.notifySpacePresent(namespace.hashCode(), System.currentTimeMillis());
        ReplacingArrayList<Object> deviceList = this.getDevicesInSpace(namespace);
        if (deviceList == null) {
            deviceList = new ReplacingArrayList();
            this.insertDevicesIntoSpace(namespace, deviceList);
            this.onSpaceEnteredEvent(namespace);
        }
        if (!this.applyFilters(eddystoneDevice)) {
            return;
        }
        if (deviceList.addOrReplace(eddystoneDevice)) {
            this.onDeviceDiscoveredEvent(namespace, eddystoneDevice);
        } else {
            this.onDevicesUpdatedEvent(namespace, deviceList);
        }
    }

    private IEddystoneNamespace extractNamespace(IEddystoneDevice eddystone) {
        for (IEddystoneNamespace namespace : this.getSpaceSet()) {
            if (!this.validator.isValid(eddystone, namespace)) continue;
            return namespace;
        }
        return null;
    }

    @Override
    public void disable() {
        this.parser.disable();
        super.disable();
    }
}

