/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.device.BeaconDevice;
import com.kontakt.sdk.android.ble.device.EddystoneDevice;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;

public class ShuffledDevicesResolver {
    private final FutureShufflesCache cache;
    private final ResolveCallback callback;

    public ShuffledDevicesResolver(ResolveCallback resolveCallback, FutureShufflesCache cache) {
        this.callback = SDKPreconditions.checkNotNull(resolveCallback);
        this.cache = SDKPreconditions.checkNotNull(cache);
        this.cache.addCallback(resolveCallback);
    }

    public void resolve(ISecureProfile secureProfile) {
        this.resolve(SecureProfileUtils.asRemoteBluetoothDevice(secureProfile));
    }

    public void resolve(RemoteBluetoothDevice originalDevice) {
        if (originalDevice == null) {
            return;
        }
        if (!originalDevice.isShuffled()) {
            this.callback.onResolved(originalDevice);
            return;
        }
        ResolvedId resolvedId = this.cache.get(originalDevice);
        if (resolvedId == null) {
            this.cache.addResolveRequest(originalDevice);
            return;
        }
        if (FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) {
            return;
        }
        if (originalDevice.getUniqueId() == null) {
            RemoteBluetoothDevice resolvedDevice = ShuffledDevicesResolver.createUpdatedDevice(originalDevice, resolvedId);
            this.callback.onResolved(resolvedDevice);
        } else {
            this.callback.onResolved(originalDevice);
        }
    }

    public void onDeviceLost(RemoteBluetoothDevice device) {
        ResolvedId resolvedId = this.cache.get(device);
        if (resolvedId == null) {
            this.cache.markIgnored(device);
        }
    }

    public void disable() {
        this.cache.finishResolveRunners();
    }

    private static RemoteBluetoothDevice createUpdatedDevice(RemoteBluetoothDevice bluetoothDevice, ResolvedId resolvedId) {
        switch (bluetoothDevice.getProfile()) {
            case IBEACON: {
                IBeaconDevice iBeaconDevice = (IBeaconDevice)bluetoothDevice;
                return BeaconDevice.of(iBeaconDevice, resolvedId);
            }
            case EDDYSTONE: {
                IEddystoneDevice eddystoneDevice = (IEddystoneDevice)bluetoothDevice;
                return new EddystoneDevice.Builder(eddystoneDevice).resolvedId(resolvedId).build();
            }
            case KONTAKT_SECURE: {
                SecureProfile secureDevice = new SecureProfile.Builder(bluetoothDevice).resolvedId(resolvedId).build();
                return SecureProfileUtils.asRemoteBluetoothDevice(secureDevice);
            }
        }
        throw new IllegalArgumentException("Unsupported device profile!");
    }

    public static interface ResolveCallback {
        public void onResolved(RemoteBluetoothDevice var1);
    }
}

