/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.connection.DeviceConnectionError;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceServiceStore;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.ble.device.KontaktDeviceCharacteristics;
import com.kontakt.sdk.android.ble.exception.ServiceAbsentException;
import com.kontakt.sdk.android.ble.spec.BluetoothDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceService;
import com.kontakt.sdk.android.ble.util.BluetoothUtils;
import com.kontakt.sdk.android.common.TimestampUtil;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

@TargetApi(value=18)
final class NormalGattController
extends BluetoothGattCallback
implements Closeable,
GattController {
    KontaktDeviceConnectionImpl connection;
    private final byte[] beaconPassword;
    private Context context;
    private Handler uiHandler;
    private BluetoothDevice bluetoothDevice;
    private BluetoothGatt gattServer;
    private KontaktDeviceServiceStore deviceServiceStore;
    private Queue<BluetoothDeviceCharacteristic> preAuthCharacteristicsQueue;
    private Runnable characteristicRequestRunnable = new Runnable(){

        @Override
        public void run() {
            if (NormalGattController.this.connection == null) {
                return;
            }
            if (NormalGattController.this.connection.getState() == KontaktDeviceConnectionImpl.State.AUTHENTICATING) {
                NormalGattController.this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING);
                NormalGattController.this.requestCharacteristics();
            }
        }
    };

    NormalGattController(KontaktDeviceConnectionImpl connection, Context context, RemoteBluetoothDevice device) throws RemoteException {
        this.connection = connection;
        this.context = context;
        this.beaconPassword = device.getPassword();
        this.uiHandler = new Handler(Looper.getMainLooper());
        BluetoothDevice bluetoothDevice = BluetoothUtils.getBluetoothDevice(device.getAddress());
        if (bluetoothDevice == null) {
            throw new RemoteException("Bluetooth device is null");
        }
        this.bluetoothDevice = bluetoothDevice;
    }

    @Override
    public boolean connect() {
        this.gattServer = this.bluetoothDevice.connectGatt(this.context, false, (BluetoothGattCallback)this);
        return this.gattServer != null;
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        switch (newState) {
            case 2: {
                if (0 == status) {
                    this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.CONNECTED);
                    this.connection.onConnectionOpened();
                    if (this.gattServer.discoverServices()) break;
                    this.connection.onError(1);
                    break;
                }
                this.connection.onError(DeviceConnectionError.toGattError(status));
                break;
            }
            case 0: {
                if (this.connection == null) break;
                if (0 != status) {
                    this.connection.onError(DeviceConnectionError.toGattError(status));
                }
                if (this.connection != null && this.connection.getState() == KontaktDeviceConnectionImpl.State.AUTHENTICATING) {
                    this.connection.onFailure(7);
                }
                if (this.connection != null) {
                    this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.DISCONNECTED);
                }
                if (this.connection == null) break;
                this.connection.onDisconnected();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported connection state change code: " + newState);
            }
        }
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        Logger.d(String.format("On Services Discovered: %s ", gatt.toString()));
        if (status != 0) {
            Logger.d("Services discovered but with no success: " + status);
            return;
        }
        try {
            this.deviceServiceStore = new KontaktDeviceServiceStore(gatt.getServices(), KontaktDeviceServiceStore.StoreType.NORMAL);
            this.connection.onServicesDiscovered(this.deviceServiceStore);
            if (this.deviceServiceStore.contains(KontaktDeviceService.DFU_SERVICE)) {
                this.connection.onDfuModeEnabled();
            } else {
                this.authorize(gatt);
            }
        }
        catch (RemoteException e) {
            this.connection.onFailure(4);
        }
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (status == 0) {
            BluetoothDeviceCharacteristic wrapper = new BluetoothDeviceCharacteristic(characteristic);
            try {
                this.deviceServiceStore.replace(wrapper);
            }
            catch (ServiceAbsentException serviceAbsentException) {
                // empty catch block
            }
            if (this.connection.getState() == KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING) {
                this.requestOrSetAuthenticated();
            }
        } else if (status == 2 && this.connection.getState() == KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING) {
            this.requestOrSetAuthenticated();
        }
    }

    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (this.connection.isConnected()) {
            try {
                this.deviceServiceStore.replace(new BluetoothDeviceCharacteristic(characteristic));
            }
            catch (ServiceAbsentException serviceAbsentException) {
                // empty catch block
            }
            boolean isSuccess = status == 0;
            KontaktDeviceCharacteristic beaconCharacteristic = KontaktDeviceCharacteristic.fromUuid(characteristic.getUuid());
            if (beaconCharacteristic == null) {
                return;
            }
            if (beaconCharacteristic == KontaktDeviceCharacteristic.PASSWORD) {
                if (isSuccess) {
                    this.uiHandler.postDelayed(this.characteristicRequestRunnable, TimeUnit.SECONDS.toMillis(1L));
                    this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.AUTHENTICATING);
                } else {
                    this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.CONNECTED);
                    this.connection.onError(3);
                }
            } else {
                this.connection.onCharacteristicWritten(isSuccess, new WriteListener.WriteResponse(TimestampUtil.getTimestamp(), null));
                if (isSuccess && this.connection != null) {
                    this.connection.notifyDataSetChanged();
                }
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.gattServer != null) {
            this.refresh();
            this.gattServer.disconnect();
        }
    }

    @Override
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        return this.gattServer.writeCharacteristic(characteristic);
    }

    @Override
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic, boolean readResponse) {
        throw new UnsupportedOperationException("Not supported in normal mode");
    }

    @Override
    public boolean readCharacteristic(BluetoothGattCharacteristic characteristic) {
        throw new UnsupportedOperationException("Not supported in normal mode");
    }

    @Override
    public boolean writeDescriptor(BluetoothGattDescriptor descriptor) {
        return false;
    }

    @Override
    public boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        return false;
    }

    @Override
    public void refresh() {
        BluetoothUtils.refreshGattServer(this.gattServer);
    }

    @Override
    public void close() {
        if (this.gattServer != null) {
            this.disconnect();
            this.gattServer.close();
        }
        if (this.deviceServiceStore != null) {
            this.deviceServiceStore.clear();
        }
        if (this.preAuthCharacteristicsQueue != null) {
            this.preAuthCharacteristicsQueue.clear();
        }
        this.connection = null;
        this.uiHandler.removeCallbacks(this.characteristicRequestRunnable);
    }

    private void requestOrSetAuthenticated() {
        if (this.preAuthCharacteristicsQueue.isEmpty()) {
            this.connection.onConnectionStateChange(KontaktDeviceConnectionImpl.State.AUTHENTICATED);
            this.connection.onAuthenticationSuccess(new KontaktDeviceCharacteristics(this.deviceServiceStore));
        } else {
            this.request(this.preAuthCharacteristicsQueue.poll());
        }
    }

    void requestCharacteristics() {
        Collection<BluetoothDeviceCharacteristic> readableCharacteristics = this.deviceServiceStore.getReadableCharacteristics();
        if (this.preAuthCharacteristicsQueue == null) {
            this.preAuthCharacteristicsQueue = new ArrayDeque<BluetoothDeviceCharacteristic>(readableCharacteristics.size());
        } else {
            this.preAuthCharacteristicsQueue.clear();
        }
        this.preAuthCharacteristicsQueue.addAll(readableCharacteristics);
        this.request(this.preAuthCharacteristicsQueue.poll());
    }

    @TargetApi(value=18)
    private void request(BluetoothDeviceCharacteristic wrapper) {
        if (!this.gattServer.readCharacteristic((BluetoothGattCharacteristic)wrapper) && this.connection != null && this.connection.getState() == KontaktDeviceConnectionImpl.State.CHARACTERISTICS_REQUESTING) {
            this.requestOrSetAuthenticated();
        }
    }

    @TargetApi(value=18)
    private void authorize(BluetoothGatt gatt) {
        try {
            BluetoothDeviceCharacteristic passwordCharacteristic = this.deviceServiceStore.getPasswordCharacteristic();
            passwordCharacteristic.setValue(this.beaconPassword);
            if (!gatt.writeCharacteristic((BluetoothGattCharacteristic)passwordCharacteristic)) {
                this.connection.onError(3);
            }
        }
        catch (Exception ignored) {
            this.connection.onError(3);
        }
    }
}

