/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.RemoteException;
import android.util.Base64;
import com.kontakt.sdk.android.ble.connection.AuthorizationCallback;
import com.kontakt.sdk.android.ble.connection.ChangeCharacteristicListener;
import com.kontakt.sdk.android.ble.connection.ErrorCause;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.GattControllerFactory;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceBatchProcessor;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceServiceStore;
import com.kontakt.sdk.android.ble.connection.KontaktGatewayConnection;
import com.kontakt.sdk.android.ble.connection.OfflineSecurityService;
import com.kontakt.sdk.android.ble.connection.OperationType;
import com.kontakt.sdk.android.ble.connection.ReadAllListener;
import com.kontakt.sdk.android.ble.connection.ReadListener;
import com.kontakt.sdk.android.ble.connection.WriteBatchListener;
import com.kontakt.sdk.android.ble.connection.WriteDescriptorListener;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.ble.device.KontaktDeviceCharacteristics;
import com.kontakt.sdk.android.ble.dfu.DfuAuthorizationService;
import com.kontakt.sdk.android.ble.dfu.DfuController;
import com.kontakt.sdk.android.ble.dfu.DfuControllerImpl;
import com.kontakt.sdk.android.ble.dfu.FirmwareUpdateListener;
import com.kontakt.sdk.android.ble.dfu.firmwares.FirmwareFilesManager;
import com.kontakt.sdk.android.ble.dfu.firmwares.IFirmwareFilesManager;
import com.kontakt.sdk.android.ble.security.auth.AuthToken;
import com.kontakt.sdk.android.ble.spec.BluetoothDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceCharacteristic;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.FirmwareRevisions;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Firmware;
import com.kontakt.sdk.android.common.model.Network;
import com.kontakt.sdk.android.common.model.Preset;
import com.kontakt.sdk.android.common.model.Time;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystonePropertyValidator;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.IBeaconPropertyValidator;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;

@TargetApi(value=18)
class KontaktDeviceConnectionImpl
implements KontaktDeviceConnection,
KontaktGatewayConnection {
    private static final String NOTIFICATION_CONFIGURATION_DESCRIPTOR_UUID = "00002902-0000-1000-8000-00805f9b34fb";
    private static final Set<State> CONNECTION_AVAILABLE_STATES = EnumSet.of(State.CONNECTED, State.AUTHENTICATED, State.AUTHENTICATING, State.CHARACTERISTICS_REQUESTING);
    volatile State state = State.DISCONNECTED;
    GattController gattController;
    private Context context;
    private RemoteBluetoothDevice device;
    private KontaktDeviceConnection.ConnectionListener connectionListener;
    private KontaktDeviceServiceStore serviceStore;
    private DfuController dfuController;
    private OfflineSecurityService offlineService;
    ReadAllListener readAllListener = ReadAllListener.noop();
    ReadListener<Time> readTimeListener = KontaktDeviceConnectionImpl.createNoopReadListener();
    ReadListener<Integer> readIntegerListener = KontaktDeviceConnectionImpl.createNoopReadListener();
    ReadListener<Network> readNetworkListener = KontaktDeviceConnectionImpl.createNoopReadListener();
    WriteListener writeListener = WriteListener.NOOP_LISTENER;
    AuthorizationCallback authorizationCallback = AuthorizationCallback.NOOP_CALLBACK;
    WriteDescriptorListener writeDescriptorListener = WriteDescriptorListener.NOOP_LISTENER;
    ChangeCharacteristicListener changeCharacteristicListener = ChangeCharacteristicListener.NOOP_LISTENER;

    KontaktDeviceConnectionImpl(Context context, RemoteBluetoothDevice bluetoothDevice, KontaktDeviceConnection.ConnectionListener connectionListener) {
        KontaktSDK.getInstance();
        SDKPreconditions.checkNotNull(bluetoothDevice, "Beacon device is null.");
        SDKPreconditions.checkNotNull(connectionListener, "Connection listener is null.");
        this.validateBeaconPassword(bluetoothDevice);
        this.context = context.getApplicationContext();
        this.device = bluetoothDevice;
        this.connectionListener = connectionListener;
    }

    KontaktDeviceConnectionImpl(Context context, ISecureProfile kontaktSecureProfile, KontaktDeviceConnection.ConnectionListener connectionListener) {
        this(context, SecureProfileUtils.asRemoteBluetoothDevice(kontaktSecureProfile), connectionListener);
    }

    protected KontaktDeviceConnectionImpl(Context context, RemoteBluetoothDevice bluetoothDevice, KontaktDeviceConnection.ConnectionListener connectionListener, KontaktDeviceServiceStore serviceStore) {
        this(context, bluetoothDevice, connectionListener);
        this.serviceStore = serviceStore;
    }

    protected KontaktDeviceConnectionImpl(Context context, ISecureProfile kontaktSecureProfile, KontaktDeviceConnection.ConnectionListener connectionListener, KontaktDeviceServiceStore serviceStore, DfuController dfuController) {
        this(context, kontaktSecureProfile, connectionListener);
        this.serviceStore = serviceStore;
        this.dfuController = dfuController;
    }

    @Override
    public RemoteBluetoothDevice getDevice() {
        return this.device;
    }

    @Override
    @TargetApi(value=18)
    public synchronized boolean connect() {
        if (!this.isClosed()) {
            throw new IllegalStateException("Previous connection is not closed.");
        }
        if (this.gattController == null) {
            try {
                this.gattController = GattControllerFactory.createGattController(this, this.context, this.device);
                return this.gattController.connect();
            }
            catch (RemoteException e) {
                Logger.e(e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    @TargetApi(value=18)
    public synchronized boolean connect(RemoteBluetoothDevice device) {
        this.device = device;
        return this.connect();
    }

    @Override
    public synchronized boolean isConnected() {
        return CONNECTION_AVAILABLE_STATES.contains((Object)this.state);
    }

    @Override
    public synchronized boolean isAuthenticated() {
        return this.state == State.AUTHENTICATED;
    }

    @Override
    @TargetApi(value=18)
    public synchronized void close() {
        if (this.isConnected()) {
            this.disconnect();
        }
        Logger.d("Closing connection");
        if (this.dfuController != null) {
            this.dfuController.close();
        }
        if (this.gattController != null) {
            this.gattController.close();
        }
        if (this.offlineService != null) {
            this.offlineService.close();
        }
        this.unregisterAllListeners();
        this.gattController = null;
        this.dfuController = null;
        this.offlineService = null;
    }

    private synchronized void disconnect() {
        if (this.gattController != null) {
            Logger.d("Disconnecting from beacon device");
            this.gattController.disconnect();
        } else {
            Logger.d("Connection was not initialized");
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.gattController == null;
    }

    @Override
    public synchronized void applyConfig(Config config, WriteBatchListener<Config> writeBatchListener) {
        SDKPreconditions.checkState(!this.isClosed(), "Beacon connection is closed");
        SDKPreconditions.checkState(this.isAuthenticated(), "Beacon connection is not authenticated");
        SDKPreconditions.checkNotNull(writeBatchListener, "Write Batch Listener is null.");
        OperationType.CONFIG.validate(this.device);
        if (!this.isAuthenticated()) {
            writeBatchListener.onWriteFailure();
            return;
        }
        Logger.d("Applying config...");
        KontaktDeviceCharacteristics characteristics = new KontaktDeviceCharacteristics(this.serviceStore);
        KontaktDeviceBatchProcessor.from(KontaktDeviceBatchProcessor.Batch.select(config, (RemoteBluetoothDevice.Characteristics)characteristics), this).process(KontaktDeviceConnectionImpl.createProcessingListener(config, writeBatchListener));
    }

    @Override
    public synchronized void acceptProfile(Preset profile, WriteBatchListener<Preset> writeBatchListener) {
        SDKPreconditions.checkState(!this.isClosed(), "Beacon connection is closed");
        SDKPreconditions.checkState(this.isAuthenticated(), "Beacon connection is not authenticated");
        SDKPreconditions.checkNotNull(writeBatchListener, "Write Batch Listener is null.");
        OperationType.PROFILE.validate(this.device);
        if (!this.isAuthenticated()) {
            writeBatchListener.onWriteFailure();
            return;
        }
        Logger.d("Accepting profile...");
        KontaktDeviceCharacteristics characteristics = new KontaktDeviceCharacteristics(this.serviceStore);
        KontaktDeviceBatchProcessor.from(KontaktDeviceBatchProcessor.Batch.select(profile, (RemoteBluetoothDevice.Characteristics)characteristics), this).process(KontaktDeviceConnectionImpl.createProcessingListener(profile, writeBatchListener));
    }

    @Override
    public synchronized void overwriteMinor(int value, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.MINOR.validate(this.device);
        Logger.d(String.format("Writing new minor value %s ", String.valueOf(value)));
        try {
            IBeaconPropertyValidator.validateMinor(value);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getMinorCharacteristic(), ConversionUtils.invert(ConversionUtils.to2ByteArray(value)), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void enableNonConnectableMode(String masterPassword, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.NON_CONNECTABLE_MODE.validate(this.device);
        try {
            IBeaconPropertyValidator.validateBeaconMasterPassword(masterPassword);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        Logger.d(String.format("Enabling non-connectable mode - master password: %s", masterPassword));
        try {
            this.overwrite(this.serviceStore.getNonConnectableCharacteristic(), masterPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteMajor(int value, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.MAJOR.validate(this.device);
        try {
            IBeaconPropertyValidator.validateMajor(value);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
        }
        Logger.d(String.format("Writing new major value - %s", String.valueOf(value)));
        try {
            this.overwrite(this.serviceStore.getMajorCharacteristic(), ConversionUtils.invert(ConversionUtils.to2ByteArray(value)), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteProximityUUID(UUID proximity, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.PROXIMITY_UUID.validate(this.device);
        try {
            SDKPreconditions.checkNotNull(proximity);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getProximityCharacteristic(), ConversionUtils.convert(proximity), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwritePassword(String newPassword, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.PASSWORD.validate(this.device);
        try {
            IBeaconPropertyValidator.validateBeaconPassword(newPassword, this.device.getFirmwareVersion());
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getSetNewPasswordCharacteristic(), newPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteModelName(String newModelName, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.MODEL_NAME.validate(this.device);
        try {
            IBeaconPropertyValidator.validateModelName(newModelName);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        byte[] modelNameBytes = newModelName.getBytes();
        Logger.d(String.format("Writing model Name - %s", newModelName));
        try {
            this.overwrite(this.serviceStore.getPropagatedDeviceNameCharacteristic(), modelNameBytes, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteAdvertisingInterval(long millis, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "Write Listener is null.");
        OperationType.ADVERTISING_INTERVAL.validate(this.device);
        try {
            IBeaconPropertyValidator.validateAdvertisingInterval((int)millis);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        Logger.d(String.format("Writing advertising interval - %s", String.valueOf(millis)));
        int value = Double.valueOf(Math.ceil((double)millis / 0.625)).intValue();
        try {
            this.overwrite(this.serviceStore.getAdvertisingIntervalCharacteristic(), ConversionUtils.invert(ConversionUtils.to2ByteArray(value)), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwritePowerLevel(int powerLevel, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.POWER_LEVEL.validate(this.device);
        try {
            IBeaconPropertyValidator.validatePowerLevel(powerLevel);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getPowerLevelCharacteristic(), ConversionUtils.convertPowerLevel(powerLevel), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void switchToDeviceProfile(DeviceProfile deviceProfile, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(deviceProfile, "DeviceProfile cannot be null");
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        SDKPreconditions.checkArgument(deviceProfile == DeviceProfile.IBEACON || deviceProfile == DeviceProfile.EDDYSTONE, "you can only switch to iBeacon or Eddystone");
        OperationType.DEVICE_PROFILE.validate(this.device);
        byte[] deviceProfileData = new byte[]{(byte)deviceProfile.getActiveProfileValue()};
        try {
            this.overwrite(this.serviceStore.getActiveProfileCharacteristic(), deviceProfileData, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void resetDevice(WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.RESET.validate(this.device);
        Logger.d("Resetting Beacon device...");
        try {
            this.overwrite(this.serviceStore.getResetCharacteristic(), new byte[]{1}, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void enableDfuMode(String masterPassword, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null.");
        OperationType.DFU.validate(this.device);
        try {
            IBeaconPropertyValidator.validateBeaconMasterPassword(masterPassword);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
        }
        try {
            this.overwrite(this.serviceStore.getBootloaderCharacteristic(), masterPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteUrl(String newUrl, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null");
        OperationType.URL.validate(this.device);
        try {
            EddystonePropertyValidator.validateUrl(newUrl);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        byte[] url = EddystoneUtils.serializeUrl(newUrl);
        try {
            this.overwrite(this.serviceStore.getUrlCharacteristic(), url, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteNamespaceId(String namespaceId, WriteListener writeListener) {
        byte[] bytes;
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty(namespaceId, "Namespace is null or empty");
        OperationType.NAMESPACE.validate(this.device);
        try {
            EddystonePropertyValidator.validateHexString(namespaceId);
            bytes = ConversionUtils.hexStringToByteArray(namespaceId);
            EddystonePropertyValidator.validateNamespace(bytes);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getNamespaceIdCharacteristic(), bytes, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteInstanceId(String instanceId, WriteListener writeListener) {
        byte[] bytes;
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty(instanceId, "Instance id is null or empty");
        OperationType.INSTANCE_ID.validate(this.device);
        try {
            EddystonePropertyValidator.validateHexString(instanceId);
            bytes = ConversionUtils.hexStringToByteArray(instanceId);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            EddystonePropertyValidator.validateHexString(instanceId);
            EddystonePropertyValidator.validateInstanceId(bytes);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getInstanceIdCharacteristic(), bytes, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void restoreDefaultSettings(String masterPassword, WriteListener writeListener) {
        OperationType.RESTORE.validate(this.device);
        Logger.d("Restoring default settings to Beacon device...");
        try {
            IBeaconPropertyValidator.validateBeaconMasterPassword(masterPassword);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getDefaultSettingsCharacteristic(), masterPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void authorize(AuthToken token, AuthorizationCallback callback) {
        SDKPreconditions.checkNotNull(token, "AuthToken can't be null");
        SDKPreconditions.checkNotNull(callback, "AuthorizationCallback can't be null");
        OperationType.AUTHORIZATION.validate(this.device);
        this.unregisterAllListeners();
        this.registerAuthorizationCallback(callback);
        byte[] decoded = Base64.decode((String)token.getToken(), (int)0);
        try {
            this.overwriteSecure(this.serviceStore.getSecureWriteCharacteristic(), decoded, WriteListener.NOOP_LISTENER, true);
        }
        catch (Exception e) {
            this.authorizationCallback.onFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.unregisterAllListeners();
        }
    }

    @Override
    public synchronized void syncTime(WriteListener listener) {
        SDKPreconditions.checkNotNull(listener, "Listener is null.");
        OperationType.SYNC_TIME.validate(this.device);
        this.unregisterAllListeners();
        try {
            Time time = Time.getCurrentUTC();
            this.overwriteSecure(this.serviceStore.getDeviceTimeCharacteristic(), time.toBleValue(), listener, false);
        }
        catch (Exception e) {
            listener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void readAll(AuthToken token, ReadListener<Config> listener) {
        SDKPreconditions.checkNotNull(token, "AuthToken is null");
        SDKPreconditions.checkNotNull(listener, "Listener is null");
        OperationType.SECURE_COMMAND.validate(this.device);
        this.unregisterAllListeners();
        this.registerReadAllListener(ReadAllListener.create(listener, token.getPassword()));
        byte[] decoded = Base64.decode((String)token.getToken(), (int)0);
        try {
            this.overwriteSecure(this.serviceStore.getSecureWriteCharacteristic(), decoded, WriteListener.NOOP_LISTENER, true);
        }
        catch (Exception e) {
            this.readAllListener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.unregisterAllListeners();
        }
    }

    @Override
    public synchronized void readTime(ReadListener<Time> listener) {
        SDKPreconditions.checkNotNull(listener, "Listener is null");
        OperationType.READ_TIME.validate(this.device);
        this.unregisterAllListeners();
        BluetoothDeviceCharacteristic characteristic = null;
        try {
            characteristic = this.serviceStore.getDeviceTimeCharacteristic();
        }
        catch (Exception e) {
            listener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.unregisterAllListeners();
        }
        this.registerReadTimeListener(listener);
        if (!this.gattController.readCharacteristic(characteristic)) {
            listener.onReadFailure(ErrorCause.GATT_FAILURE);
            this.unregisterAllListeners();
        }
    }

    @Override
    public synchronized void readLightSensor(ReadListener<Integer> listener) {
        BluetoothGattDescriptor descriptor;
        BluetoothDeviceCharacteristic characteristic;
        SDKPreconditions.checkNotNull(listener, "Listener is null");
        OperationType.READ_LIGHT_SENSOR.validate(this.device);
        this.unregisterAllListeners();
        try {
            characteristic = this.serviceStore.getLightSensorCharacteristic();
            descriptor = characteristic.getDescriptor(UUID.fromString(NOTIFICATION_CONFIGURATION_DESCRIPTOR_UUID));
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
        }
        catch (Exception e) {
            listener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.unregisterAllListeners();
            return;
        }
        this.registerReadIntListener(listener);
        if (!this.gattController.setCharacteristicNotification(characteristic, true) || !this.gattController.writeDescriptor(descriptor)) {
            listener.onReadFailure(ErrorCause.GATT_FAILURE);
            this.unregisterAllListeners();
        }
    }

    @Override
    public synchronized void applySecureConfig(String encryptedConfig, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty(encryptedConfig, "Secure config is null or empty");
        this.unregisterAllListeners();
        OperationType.SECURE_CONFIG.validate(this.device);
        byte[] decodedConfig = Base64.decode((String)encryptedConfig, (int)0);
        try {
            this.overwriteSecure(this.serviceStore.getSecureWriteCharacteristic(), decodedConfig, writeListener, true);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void applySecureConfig(Config config, AuthToken token, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(config, "Config is null");
        SDKPreconditions.checkNotNull(token, "AuthToken is null");
        SDKPreconditions.checkNotNull(writeListener, "Listener is null");
        this.unregisterAllListeners();
        if (this.offlineService == null) {
            this.offlineService = new OfflineSecurityService(this);
        }
        this.offlineService.applySecureConfig(config, token, writeListener);
    }

    @Override
    public void updateFirmware(Firmware firmware, KontaktCloud kontaktCloud, FirmwareUpdateListener firmwareUpdateListener) {
        this.updateFirmware(firmware, null, kontaktCloud, firmwareUpdateListener);
    }

    @Override
    public void updateFirmware(Firmware firmware, byte[] fileBytes, KontaktCloud kontaktCloud, FirmwareUpdateListener firmwareUpdateListener) {
        SDKPreconditions.checkState(!this.isClosed(), "The connection is closed");
        SDKPreconditions.checkState(this.isAuthenticated(), "The device is not authenticated");
        SDKPreconditions.checkNotNull(kontaktCloud, "KontaktCloud is null");
        SDKPreconditions.checkNotNull(firmware, "Firmware is null");
        SDKPreconditions.checkNotNull(firmwareUpdateListener, "FirmwareUpdateListener is null");
        SDKPreconditions.checkArgument(this.device.getProfile() == DeviceProfile.KONTAKT_SECURE, "Firmware update is meant only for Kontakt.io secure profile devices (Beacon PRO and above)");
        if (this.dfuController == null) {
            IFirmwareFilesManager firmwareFilesManager = FirmwareFilesManager.create(this.context, kontaktCloud);
            DfuAuthorizationService authorizationService = DfuAuthorizationService.create(this.device, kontaktCloud, this.gattController, this.serviceStore);
            this.dfuController = DfuControllerImpl.create(fileBytes, firmware, this.gattController, this.serviceStore, firmwareFilesManager, authorizationService);
        }
        this.dfuController.setFirmwareUpdateListener(firmwareUpdateListener);
        this.registerWriteListener(this.dfuController);
        this.registerChangeListener(this.dfuController);
        this.registerWriteDescriptorListener(this.dfuController);
        this.dfuController.initialize();
    }

    @Override
    public void readNetworksCount(ReadListener<Integer> listener) {
        SDKPreconditions.checkNotNull(listener, "Listener is null");
        OperationType.GATEWAY_READ_NETWORK_COUNT.validate(this.device);
        this.unregisterAllListeners();
        BluetoothDeviceCharacteristic characteristic = null;
        try {
            characteristic = this.serviceStore.getGatewayNetworkCountCharacteristic();
        }
        catch (Exception e) {
            listener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.unregisterAllListeners();
        }
        this.registerReadIntListener(listener);
        if (!this.gattController.readCharacteristic(characteristic)) {
            listener.onReadFailure(ErrorCause.GATT_FAILURE);
            this.unregisterAllListeners();
        }
    }

    @Override
    public void selectNetworkToRead(int index, WriteListener listener) {
        SDKPreconditions.checkNotNull(listener, "WriteListener is null.");
        OperationType.GATEWAY_SELECT_NETWORK.validate(this.device);
        try {
            byte[] value = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(index).array();
            this.overwrite(this.serviceStore.getGatewayNetworkIndexCharacteristic(), value, listener);
        }
        catch (Exception e) {
            listener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public void readSelectedNetwork(ReadListener<Network> listener) {
        SDKPreconditions.checkNotNull(listener, "Listener is null");
        OperationType.GATEWAY_READ_NETWORK.validate(this.device);
        this.unregisterAllListeners();
        BluetoothDeviceCharacteristic characteristic = null;
        try {
            characteristic = this.serviceStore.getGatewayNetworkRecordCharacteristic();
        }
        catch (Exception e) {
            listener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.unregisterAllListeners();
        }
        this.registerReadNetworksListener(listener);
        if (!this.gattController.readCharacteristic(characteristic)) {
            listener.onReadFailure(ErrorCause.GATT_FAILURE);
            this.unregisterAllListeners();
        }
    }

    @Override
    public synchronized void executeSecureCommand(String secureCommand, WriteListener writeListener) {
        SDKPreconditions.checkNotNull(writeListener, "WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty(secureCommand, "Secure command is null or empty");
        OperationType.SECURE_COMMAND.validate(this.device);
        byte[] decodedCommand = Base64.decode((String)secureCommand, (int)0);
        try {
            this.overwriteSecure(this.serviceStore.getSecureWriteCharacteristic(), decodedCommand, writeListener, false);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    @TargetApi(value=18)
    protected synchronized void overwrite(BluetoothGattCharacteristic characteristic, byte[] newValue, WriteListener listener) {
        SDKPreconditions.checkState(!this.isClosed(), "The connection is closed");
        SDKPreconditions.checkState(this.isAuthenticated(), "The device is not authenticated");
        this.registerWriteListener(listener);
        byte[] currentValue = characteristic.getValue();
        characteristic.setValue(newValue);
        Logger.d(String.format("Writing value %s to characteristic %s", new String(newValue), characteristic.getUuid().toString()));
        if (!this.gattController.writeCharacteristic(characteristic)) {
            characteristic.setValue(currentValue);
            this.writeListener.onWriteFailure(ErrorCause.GATT_FAILURE);
            this.unregisterAllListeners();
        }
    }

    @TargetApi(value=18)
    protected synchronized void overwriteSecure(BluetoothGattCharacteristic characteristic, byte[] newValue, WriteListener listener, boolean readResponse) {
        SDKPreconditions.checkState(!this.isClosed(), "The connection is closed");
        SDKPreconditions.checkState(this.isAuthenticated(), "The device is not authenticated");
        this.registerWriteListener(listener);
        byte[] currentValue = characteristic.getValue();
        characteristic.setValue(newValue);
        Logger.d(String.format("Writing value %s to characteristic %s", new String(newValue), characteristic.getUuid().toString()));
        if (!this.gattController.writeCharacteristic(characteristic, readResponse)) {
            characteristic.setValue(currentValue);
            this.writeListener.onWriteFailure(ErrorCause.GATT_FAILURE);
            this.readAllListener.onReadFailure(ErrorCause.GATT_FAILURE);
            this.authorizationCallback.onFailure(ErrorCause.GATT_FAILURE);
            this.unregisterAllListeners();
        }
    }

    State getState() {
        return this.state;
    }

    void finishWriteBatch() {
        this.unregisterAllListeners();
    }

    void onDisconnected() {
        this.serviceStore = null;
        this.connectionListener.onDisconnected();
    }

    void onDfuModeEnabled() {
    }

    void onServicesDiscovered(KontaktDeviceServiceStore serviceStore) {
        this.serviceStore = serviceStore;
    }

    void onAuthenticationSuccess(RemoteBluetoothDevice.Characteristics deviceCharacteristics) {
        this.connectionListener.onAuthenticationSuccess(deviceCharacteristics);
    }

    void onError(int errorCode) {
        this.connectionListener.onErrorOccured(errorCode);
    }

    void onFailure(int failureCode) {
        this.connectionListener.onAuthenticationFailure(failureCode);
    }

    void onConnectionStateChange(State state) {
        this.state = state;
    }

    void onCharacteristicWritten(boolean isSuccess, WriteListener.WriteResponse response) {
        if (isSuccess) {
            this.writeListener.onWriteSuccess(response);
            this.readAllListener.onResponseReceived(response.getExtra());
            this.authorizationCallback.onSuccess();
        } else {
            this.writeListener.onWriteFailure(ErrorCause.GATT_FAILURE);
            this.readAllListener.onReadFailure(ErrorCause.GATT_FAILURE);
            this.authorizationCallback.onFailure(ErrorCause.GATT_FAILURE);
        }
    }

    void onCharacteristicRead(BluetoothDeviceCharacteristic characteristic) {
        try {
            String uuid = characteristic.getUuid().toString();
            if (KontaktDeviceCharacteristic.CURRENT_TIME.getId().equals(uuid)) {
                this.readTimeListener.onReadSuccess(Time.fromBleValue(characteristic.getValue()));
            } else if (KontaktDeviceCharacteristic.GATEWAY_NETWORKS_LENGTH.getId().equals(uuid)) {
                int intValue = ByteBuffer.wrap(characteristic.getValue()).order(ByteOrder.LITTLE_ENDIAN).getInt();
                this.readIntegerListener.onReadSuccess(intValue);
            } else if (KontaktDeviceCharacteristic.GATEWAY_NETWORKS_RECORD.getId().equals(uuid)) {
                byte[] value = characteristic.getValue();
                this.readNetworkListener.onReadSuccess(Network.fromBleValue(value));
            }
        }
        catch (Exception e) {
            this.readTimeListener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.readIntegerListener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
            this.readNetworkListener.onReadFailure(ErrorCause.FEATURE_NOT_SUPPORTED);
        }
    }

    void onCharacteristicChanged(BluetoothDeviceCharacteristic characteristic) {
        String uuid = characteristic.getUuid().toString();
        if (KontaktDeviceCharacteristic.LIGHT_SENSOR_PERCENTAGE.getId().equals(uuid)) {
            this.readIntegerListener.onReadSuccess(characteristic.getIntValue());
        } else {
            this.changeCharacteristicListener.onCharacteristicChanged(characteristic);
        }
    }

    void onDescriptorWritten(boolean isSuccess, BluetoothGattDescriptor descriptor) {
        if (isSuccess) {
            this.writeDescriptorListener.onDescriptorWriteSuccess(descriptor);
        } else {
            this.writeDescriptorListener.onDescriptorWriteFailure(descriptor);
        }
    }

    void onConnectionOpened() {
        this.connectionListener.onConnectionOpened();
    }

    void notifyDataSetChanged() {
        this.connectionListener.onCharacteristicsUpdated(new KontaktDeviceCharacteristics(this.serviceStore));
    }

    private void registerAuthorizationCallback(AuthorizationCallback callback) {
        this.authorizationCallback = callback;
    }

    private void registerWriteListener(WriteListener writeListener) {
        this.writeListener = writeListener;
    }

    private void registerChangeListener(ChangeCharacteristicListener listener) {
        this.changeCharacteristicListener = listener;
    }

    private void registerWriteDescriptorListener(WriteDescriptorListener listener) {
        this.writeDescriptorListener = listener;
    }

    private void registerReadAllListener(ReadAllListener readListener) {
        this.readAllListener = readListener;
    }

    private void registerReadTimeListener(ReadListener<Time> readListener) {
        this.readTimeListener = readListener;
    }

    private void registerReadIntListener(ReadListener<Integer> readListener) {
        this.readIntegerListener = readListener;
    }

    private void registerReadNetworksListener(ReadListener<Network> readListener) {
        this.readNetworkListener = readListener;
    }

    void unregisterAllListeners() {
        this.writeListener = WriteListener.NOOP_LISTENER;
        this.changeCharacteristicListener = ChangeCharacteristicListener.NOOP_LISTENER;
        this.writeDescriptorListener = WriteDescriptorListener.NOOP_LISTENER;
        this.authorizationCallback = AuthorizationCallback.NOOP_CALLBACK;
        this.readTimeListener = KontaktDeviceConnectionImpl.createNoopReadListener();
        this.readAllListener = ReadAllListener.noop();
    }

    private void validateBeaconPassword(RemoteBluetoothDevice remoteBluetoothDevice) {
        if (FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(remoteBluetoothDevice.getFirmwareVersion())) {
            SDKPreconditions.checkNotNull(remoteBluetoothDevice.getPassword(), "Beacon password is null or empty.");
            IBeaconPropertyValidator.validateBeaconPassword(new String(remoteBluetoothDevice.getPassword()), remoteBluetoothDevice.getFirmwareVersion());
        }
    }

    private static <T> KontaktDeviceBatchProcessor.ProcessingListener createProcessingListener(final T batchHolder, final WriteBatchListener<T> writeBatchListener) {
        return new KontaktDeviceBatchProcessor.ProcessingListener(){

            @Override
            public void onStart() {
                writeBatchListener.onWriteBatchStart(batchHolder);
            }

            @Override
            public void onError(int errorCode) {
                writeBatchListener.onErrorOccured(errorCode);
            }

            @Override
            public void onFinish() {
                writeBatchListener.onWriteBatchFinish(batchHolder);
            }

            @Override
            public void onRollbackStart() {
            }

            @Override
            public void onRollbackFinish() {
            }

            @Override
            public void onRollbackError(int errorCode) {
            }
        };
    }

    private static <T> ReadListener<T> createNoopReadListener() {
        return new ReadListener<T>(){

            @Override
            public void onReadSuccess(T value) {
            }

            @Override
            public void onReadFailure(ErrorCause cause) {
            }
        };
    }

    public static enum State {
        CONNECTED,
        AUTHENTICATING,
        CHARACTERISTICS_REQUESTING,
        AUTHENTICATED,
        DISCONNECTED;

    }
}

